/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteLearningAssignmentRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteLearningModuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningAssignmentRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningAssignmentsMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningAssignmentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModuleJobRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModuleRuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModuleVersionRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModulesAssignmentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModulesCoverartCoverArtIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetLearningModulesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchLearningAssignmentRequest;
import com.mypurecloud.sdk.v2.api.request.PatchLearningAssignmentRescheduleRequest;
import com.mypurecloud.sdk.v2.api.request.PatchLearningModuleUserAssignmentsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssessmentsScoringRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentReassignRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentResetRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentsAggregatesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentsBulkaddRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentsBulkremoveRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningAssignmentsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningModuleJobsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningModulePublishRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningModulesRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningRulesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostLearningScheduleslotsQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PutLearningModuleRequest;
import com.mypurecloud.sdk.v2.api.request.PutLearningModuleRuleRequest;
import com.mypurecloud.sdk.v2.model.AssessmentScoringSet;
import com.mypurecloud.sdk.v2.model.AssignedLearningModuleDomainEntityListing;
import com.mypurecloud.sdk.v2.model.LearningAssessmentScoringRequest;
import com.mypurecloud.sdk.v2.model.LearningAssignment;
import com.mypurecloud.sdk.v2.model.LearningAssignmentAggregateParam;
import com.mypurecloud.sdk.v2.model.LearningAssignmentAggregateResponse;
import com.mypurecloud.sdk.v2.model.LearningAssignmentBulkAddResponse;
import com.mypurecloud.sdk.v2.model.LearningAssignmentBulkRemoveResponse;
import com.mypurecloud.sdk.v2.model.LearningAssignmentCreate;
import com.mypurecloud.sdk.v2.model.LearningAssignmentExternalUpdate;
import com.mypurecloud.sdk.v2.model.LearningAssignmentItem;
import com.mypurecloud.sdk.v2.model.LearningAssignmentReschedule;
import com.mypurecloud.sdk.v2.model.LearningAssignmentUpdate;
import com.mypurecloud.sdk.v2.model.LearningAssignmentUserListing;
import com.mypurecloud.sdk.v2.model.LearningAssignmentUserQuery;
import com.mypurecloud.sdk.v2.model.LearningAssignmentsDomainEntity;
import com.mypurecloud.sdk.v2.model.LearningModule;
import com.mypurecloud.sdk.v2.model.LearningModuleCoverArtResponse;
import com.mypurecloud.sdk.v2.model.LearningModuleJobRequest;
import com.mypurecloud.sdk.v2.model.LearningModuleJobResponse;
import com.mypurecloud.sdk.v2.model.LearningModulePublishRequest;
import com.mypurecloud.sdk.v2.model.LearningModulePublishResponse;
import com.mypurecloud.sdk.v2.model.LearningModuleRequest;
import com.mypurecloud.sdk.v2.model.LearningModuleRule;
import com.mypurecloud.sdk.v2.model.LearningModulesDomainEntityListing;
import com.mypurecloud.sdk.v2.model.LearningScheduleSlotsQueryRequest;
import com.mypurecloud.sdk.v2.model.LearningScheduleSlotsQueryResponse;
import java.io.IOException;
import java.util.List;

public class LearningApi {
    private final ApiClient pcapiClient;

    public LearningApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LearningApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteLearningAssignment(String assignmentId) throws IOException, ApiException {
        this.deleteLearningAssignment(this.createDeleteLearningAssignmentRequest(assignmentId));
    }

    public ApiResponse<Void> deleteLearningAssignmentWithHttpInfo(String assignmentId) throws IOException {
        return this.deleteLearningAssignment(this.createDeleteLearningAssignmentRequest(assignmentId).withHttpInfo());
    }

    private DeleteLearningAssignmentRequest createDeleteLearningAssignmentRequest(String assignmentId) {
        return DeleteLearningAssignmentRequest.builder().withAssignmentId(assignmentId).build();
    }

    public void deleteLearningAssignment(DeleteLearningAssignmentRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteLearningAssignment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteLearningModule(String moduleId) throws IOException, ApiException {
        this.deleteLearningModule(this.createDeleteLearningModuleRequest(moduleId));
    }

    public ApiResponse<Void> deleteLearningModuleWithHttpInfo(String moduleId) throws IOException {
        return this.deleteLearningModule(this.createDeleteLearningModuleRequest(moduleId).withHttpInfo());
    }

    private DeleteLearningModuleRequest createDeleteLearningModuleRequest(String moduleId) {
        return DeleteLearningModuleRequest.builder().withModuleId(moduleId).build();
    }

    public void deleteLearningModule(DeleteLearningModuleRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteLearningModule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment getLearningAssignment(String assignmentId, List<String> expand) throws IOException, ApiException {
        return this.getLearningAssignment(this.createGetLearningAssignmentRequest(assignmentId, expand));
    }

    public ApiResponse<LearningAssignment> getLearningAssignmentWithHttpInfo(String assignmentId, List<String> expand) throws IOException {
        return this.getLearningAssignment(this.createGetLearningAssignmentRequest(assignmentId, expand).withHttpInfo());
    }

    private GetLearningAssignmentRequest createGetLearningAssignmentRequest(String assignmentId, List<String> expand) {
        return GetLearningAssignmentRequest.builder().withAssignmentId(assignmentId).withExpand(expand).build();
    }

    public LearningAssignment getLearningAssignment(GetLearningAssignmentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> getLearningAssignment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentsDomainEntity getLearningAssignments(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> userId, List<String> types, List<String> states, List<String> expand) throws IOException, ApiException {
        return this.getLearningAssignments(this.createGetLearningAssignmentsRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, pass, minPercentageScore, maxPercentageScore, sortOrder, sortBy, userId, types, states, expand));
    }

    public ApiResponse<LearningAssignmentsDomainEntity> getLearningAssignmentsWithHttpInfo(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> userId, List<String> types, List<String> states, List<String> expand) throws IOException {
        return this.getLearningAssignments(this.createGetLearningAssignmentsRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, pass, minPercentageScore, maxPercentageScore, sortOrder, sortBy, userId, types, states, expand).withHttpInfo());
    }

    private GetLearningAssignmentsRequest createGetLearningAssignmentsRequest(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> userId, List<String> types, List<String> states, List<String> expand) {
        return GetLearningAssignmentsRequest.builder().withModuleId(moduleId).withInterval(interval).withCompletionInterval(completionInterval).withOverdue(overdue).withPageSize(pageSize).withPageNumber(pageNumber).withPass(pass).withMinPercentageScore(minPercentageScore).withMaxPercentageScore(maxPercentageScore).withSortOrder(sortOrder).withSortBy(sortBy).withUserId(userId).withTypes(types).withStates(states).withExpand(expand).build();
    }

    public LearningAssignmentsDomainEntity getLearningAssignments(GetLearningAssignmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentsDomainEntity> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentsDomainEntity>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentsDomainEntity> getLearningAssignments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentsDomainEntity>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentsDomainEntity getLearningAssignmentsMe(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> types, List<String> states, List<String> expand) throws IOException, ApiException {
        return this.getLearningAssignmentsMe(this.createGetLearningAssignmentsMeRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, pass, minPercentageScore, maxPercentageScore, sortOrder, sortBy, types, states, expand));
    }

    public ApiResponse<LearningAssignmentsDomainEntity> getLearningAssignmentsMeWithHttpInfo(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> types, List<String> states, List<String> expand) throws IOException {
        return this.getLearningAssignmentsMe(this.createGetLearningAssignmentsMeRequest(moduleId, interval, completionInterval, overdue, pageSize, pageNumber, pass, minPercentageScore, maxPercentageScore, sortOrder, sortBy, types, states, expand).withHttpInfo());
    }

    private GetLearningAssignmentsMeRequest createGetLearningAssignmentsMeRequest(String moduleId, String interval, String completionInterval, String overdue, Integer pageSize, Integer pageNumber, String pass, Float minPercentageScore, Float maxPercentageScore, String sortOrder, String sortBy, List<String> types, List<String> states, List<String> expand) {
        return GetLearningAssignmentsMeRequest.builder().withModuleId(moduleId).withInterval(interval).withCompletionInterval(completionInterval).withOverdue(overdue).withPageSize(pageSize).withPageNumber(pageNumber).withPass(pass).withMinPercentageScore(minPercentageScore).withMaxPercentageScore(maxPercentageScore).withSortOrder(sortOrder).withSortBy(sortBy).withTypes(types).withStates(states).withExpand(expand).build();
    }

    public LearningAssignmentsDomainEntity getLearningAssignmentsMe(GetLearningAssignmentsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentsDomainEntity> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentsDomainEntity>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentsDomainEntity> getLearningAssignmentsMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentsDomainEntity>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModule getLearningModule(String moduleId, List<String> expand) throws IOException, ApiException {
        return this.getLearningModule(this.createGetLearningModuleRequest(moduleId, expand));
    }

    public ApiResponse<LearningModule> getLearningModuleWithHttpInfo(String moduleId, List<String> expand) throws IOException {
        return this.getLearningModule(this.createGetLearningModuleRequest(moduleId, expand).withHttpInfo());
    }

    private GetLearningModuleRequest createGetLearningModuleRequest(String moduleId, List<String> expand) {
        return GetLearningModuleRequest.builder().withModuleId(moduleId).withExpand(expand).build();
    }

    public LearningModule getLearningModule(GetLearningModuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModule> getLearningModule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModuleJobResponse getLearningModuleJob(String moduleId, String jobId) throws IOException, ApiException {
        return this.getLearningModuleJob(this.createGetLearningModuleJobRequest(moduleId, jobId));
    }

    public ApiResponse<LearningModuleJobResponse> getLearningModuleJobWithHttpInfo(String moduleId, String jobId) throws IOException {
        return this.getLearningModuleJob(this.createGetLearningModuleJobRequest(moduleId, jobId).withHttpInfo());
    }

    private GetLearningModuleJobRequest createGetLearningModuleJobRequest(String moduleId, String jobId) {
        return GetLearningModuleJobRequest.builder().withModuleId(moduleId).withJobId(jobId).build();
    }

    public LearningModuleJobResponse getLearningModuleJob(GetLearningModuleJobRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModuleJobResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModuleJobResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModuleJobResponse> getLearningModuleJob(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModuleJobResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModuleRule getLearningModuleRule(String moduleId) throws IOException, ApiException {
        return this.getLearningModuleRule(this.createGetLearningModuleRuleRequest(moduleId));
    }

    public ApiResponse<LearningModuleRule> getLearningModuleRuleWithHttpInfo(String moduleId) throws IOException {
        return this.getLearningModuleRule(this.createGetLearningModuleRuleRequest(moduleId).withHttpInfo());
    }

    private GetLearningModuleRuleRequest createGetLearningModuleRuleRequest(String moduleId) {
        return GetLearningModuleRuleRequest.builder().withModuleId(moduleId).build();
    }

    public LearningModuleRule getLearningModuleRule(GetLearningModuleRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModuleRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModuleRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModuleRule> getLearningModuleRule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModuleRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModule getLearningModuleVersion(String moduleId, String versionId, List<String> expand) throws IOException, ApiException {
        return this.getLearningModuleVersion(this.createGetLearningModuleVersionRequest(moduleId, versionId, expand));
    }

    public ApiResponse<LearningModule> getLearningModuleVersionWithHttpInfo(String moduleId, String versionId, List<String> expand) throws IOException {
        return this.getLearningModuleVersion(this.createGetLearningModuleVersionRequest(moduleId, versionId, expand).withHttpInfo());
    }

    private GetLearningModuleVersionRequest createGetLearningModuleVersionRequest(String moduleId, String versionId, List<String> expand) {
        return GetLearningModuleVersionRequest.builder().withModuleId(moduleId).withVersionId(versionId).withExpand(expand).build();
    }

    public LearningModule getLearningModuleVersion(GetLearningModuleVersionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModule> getLearningModuleVersion(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModulesDomainEntityListing getLearningModules(Boolean isArchived, List<String> types, Integer pageSize, Integer pageNumber, String sortOrder, String sortBy, String searchTerm, List<String> expand, String isPublished, List<String> statuses, List<String> externalIds) throws IOException, ApiException {
        return this.getLearningModules(this.createGetLearningModulesRequest(isArchived, types, pageSize, pageNumber, sortOrder, sortBy, searchTerm, expand, isPublished, statuses, externalIds));
    }

    public ApiResponse<LearningModulesDomainEntityListing> getLearningModulesWithHttpInfo(Boolean isArchived, List<String> types, Integer pageSize, Integer pageNumber, String sortOrder, String sortBy, String searchTerm, List<String> expand, String isPublished, List<String> statuses, List<String> externalIds) throws IOException {
        return this.getLearningModules(this.createGetLearningModulesRequest(isArchived, types, pageSize, pageNumber, sortOrder, sortBy, searchTerm, expand, isPublished, statuses, externalIds).withHttpInfo());
    }

    private GetLearningModulesRequest createGetLearningModulesRequest(Boolean isArchived, List<String> types, Integer pageSize, Integer pageNumber, String sortOrder, String sortBy, String searchTerm, List<String> expand, String isPublished, List<String> statuses, List<String> externalIds) {
        return GetLearningModulesRequest.builder().withIsArchived(isArchived).withTypes(types).withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).withSortBy(sortBy).withSearchTerm(searchTerm).withExpand(expand).withIsPublished(isPublished).withStatuses(statuses).withExternalIds(externalIds).build();
    }

    public LearningModulesDomainEntityListing getLearningModules(GetLearningModulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModulesDomainEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModulesDomainEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModulesDomainEntityListing> getLearningModules(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModulesDomainEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssignedLearningModuleDomainEntityListing getLearningModulesAssignments(List<String> userIds, Integer pageSize, Integer pageNumber, String searchTerm, String overdue, List<String> assignmentStates, List<String> expand) throws IOException, ApiException {
        return this.getLearningModulesAssignments(this.createGetLearningModulesAssignmentsRequest(userIds, pageSize, pageNumber, searchTerm, overdue, assignmentStates, expand));
    }

    public ApiResponse<AssignedLearningModuleDomainEntityListing> getLearningModulesAssignmentsWithHttpInfo(List<String> userIds, Integer pageSize, Integer pageNumber, String searchTerm, String overdue, List<String> assignmentStates, List<String> expand) throws IOException {
        return this.getLearningModulesAssignments(this.createGetLearningModulesAssignmentsRequest(userIds, pageSize, pageNumber, searchTerm, overdue, assignmentStates, expand).withHttpInfo());
    }

    private GetLearningModulesAssignmentsRequest createGetLearningModulesAssignmentsRequest(List<String> userIds, Integer pageSize, Integer pageNumber, String searchTerm, String overdue, List<String> assignmentStates, List<String> expand) {
        return GetLearningModulesAssignmentsRequest.builder().withUserIds(userIds).withPageSize(pageSize).withPageNumber(pageNumber).withSearchTerm(searchTerm).withOverdue(overdue).withAssignmentStates(assignmentStates).withExpand(expand).build();
    }

    public AssignedLearningModuleDomainEntityListing getLearningModulesAssignments(GetLearningModulesAssignmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssignedLearningModuleDomainEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssignedLearningModuleDomainEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssignedLearningModuleDomainEntityListing> getLearningModulesAssignments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssignedLearningModuleDomainEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModuleCoverArtResponse getLearningModulesCoverartCoverArtId(String coverArtId) throws IOException, ApiException {
        return this.getLearningModulesCoverartCoverArtId(this.createGetLearningModulesCoverartCoverArtIdRequest(coverArtId));
    }

    public ApiResponse<LearningModuleCoverArtResponse> getLearningModulesCoverartCoverArtIdWithHttpInfo(String coverArtId) throws IOException {
        return this.getLearningModulesCoverartCoverArtId(this.createGetLearningModulesCoverartCoverArtIdRequest(coverArtId).withHttpInfo());
    }

    private GetLearningModulesCoverartCoverArtIdRequest createGetLearningModulesCoverartCoverArtIdRequest(String coverArtId) {
        return GetLearningModulesCoverartCoverArtIdRequest.builder().withCoverArtId(coverArtId).build();
    }

    public LearningModuleCoverArtResponse getLearningModulesCoverartCoverArtId(GetLearningModulesCoverartCoverArtIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModuleCoverArtResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModuleCoverArtResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModuleCoverArtResponse> getLearningModulesCoverartCoverArtId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModuleCoverArtResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment patchLearningAssignment(String assignmentId, LearningAssignmentUpdate body) throws IOException, ApiException {
        return this.patchLearningAssignment(this.createPatchLearningAssignmentRequest(assignmentId, body));
    }

    public ApiResponse<LearningAssignment> patchLearningAssignmentWithHttpInfo(String assignmentId, LearningAssignmentUpdate body) throws IOException {
        return this.patchLearningAssignment(this.createPatchLearningAssignmentRequest(assignmentId, body).withHttpInfo());
    }

    private PatchLearningAssignmentRequest createPatchLearningAssignmentRequest(String assignmentId, LearningAssignmentUpdate body) {
        return PatchLearningAssignmentRequest.builder().withAssignmentId(assignmentId).withBody(body).build();
    }

    public LearningAssignment patchLearningAssignment(PatchLearningAssignmentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> patchLearningAssignment(ApiRequest<LearningAssignmentUpdate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment patchLearningAssignmentReschedule(String assignmentId, LearningAssignmentReschedule body) throws IOException, ApiException {
        return this.patchLearningAssignmentReschedule(this.createPatchLearningAssignmentRescheduleRequest(assignmentId, body));
    }

    public ApiResponse<LearningAssignment> patchLearningAssignmentRescheduleWithHttpInfo(String assignmentId, LearningAssignmentReschedule body) throws IOException {
        return this.patchLearningAssignmentReschedule(this.createPatchLearningAssignmentRescheduleRequest(assignmentId, body).withHttpInfo());
    }

    private PatchLearningAssignmentRescheduleRequest createPatchLearningAssignmentRescheduleRequest(String assignmentId, LearningAssignmentReschedule body) {
        return PatchLearningAssignmentRescheduleRequest.builder().withAssignmentId(assignmentId).withBody(body).build();
    }

    public LearningAssignment patchLearningAssignmentReschedule(PatchLearningAssignmentRescheduleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> patchLearningAssignmentReschedule(ApiRequest<LearningAssignmentReschedule> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment patchLearningModuleUserAssignments(String moduleId, String userId, LearningAssignmentExternalUpdate body) throws IOException, ApiException {
        return this.patchLearningModuleUserAssignments(this.createPatchLearningModuleUserAssignmentsRequest(moduleId, userId, body));
    }

    public ApiResponse<LearningAssignment> patchLearningModuleUserAssignmentsWithHttpInfo(String moduleId, String userId, LearningAssignmentExternalUpdate body) throws IOException {
        return this.patchLearningModuleUserAssignments(this.createPatchLearningModuleUserAssignmentsRequest(moduleId, userId, body).withHttpInfo());
    }

    private PatchLearningModuleUserAssignmentsRequest createPatchLearningModuleUserAssignmentsRequest(String moduleId, String userId, LearningAssignmentExternalUpdate body) {
        return PatchLearningModuleUserAssignmentsRequest.builder().withModuleId(moduleId).withUserId(userId).withBody(body).build();
    }

    public LearningAssignment patchLearningModuleUserAssignments(PatchLearningModuleUserAssignmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> patchLearningModuleUserAssignments(ApiRequest<LearningAssignmentExternalUpdate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssessmentScoringSet postLearningAssessmentsScoring(LearningAssessmentScoringRequest body) throws IOException, ApiException {
        return this.postLearningAssessmentsScoring(this.createPostLearningAssessmentsScoringRequest(body));
    }

    public ApiResponse<AssessmentScoringSet> postLearningAssessmentsScoringWithHttpInfo(LearningAssessmentScoringRequest body) throws IOException {
        return this.postLearningAssessmentsScoring(this.createPostLearningAssessmentsScoringRequest(body).withHttpInfo());
    }

    private PostLearningAssessmentsScoringRequest createPostLearningAssessmentsScoringRequest(LearningAssessmentScoringRequest body) {
        return PostLearningAssessmentsScoringRequest.builder().withBody(body).build();
    }

    public AssessmentScoringSet postLearningAssessmentsScoring(PostLearningAssessmentsScoringRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssessmentScoringSet> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssessmentScoringSet>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssessmentScoringSet> postLearningAssessmentsScoring(ApiRequest<LearningAssessmentScoringRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssessmentScoringSet>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment postLearningAssignmentReassign(String assignmentId) throws IOException, ApiException {
        return this.postLearningAssignmentReassign(this.createPostLearningAssignmentReassignRequest(assignmentId));
    }

    public ApiResponse<LearningAssignment> postLearningAssignmentReassignWithHttpInfo(String assignmentId) throws IOException {
        return this.postLearningAssignmentReassign(this.createPostLearningAssignmentReassignRequest(assignmentId).withHttpInfo());
    }

    private PostLearningAssignmentReassignRequest createPostLearningAssignmentReassignRequest(String assignmentId) {
        return PostLearningAssignmentReassignRequest.builder().withAssignmentId(assignmentId).build();
    }

    public LearningAssignment postLearningAssignmentReassign(PostLearningAssignmentReassignRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> postLearningAssignmentReassign(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment postLearningAssignmentReset(String assignmentId) throws IOException, ApiException {
        return this.postLearningAssignmentReset(this.createPostLearningAssignmentResetRequest(assignmentId));
    }

    public ApiResponse<LearningAssignment> postLearningAssignmentResetWithHttpInfo(String assignmentId) throws IOException {
        return this.postLearningAssignmentReset(this.createPostLearningAssignmentResetRequest(assignmentId).withHttpInfo());
    }

    private PostLearningAssignmentResetRequest createPostLearningAssignmentResetRequest(String assignmentId) {
        return PostLearningAssignmentResetRequest.builder().withAssignmentId(assignmentId).build();
    }

    public LearningAssignment postLearningAssignmentReset(PostLearningAssignmentResetRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> postLearningAssignmentReset(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignment postLearningAssignments(LearningAssignmentCreate body) throws IOException, ApiException {
        return this.postLearningAssignments(this.createPostLearningAssignmentsRequest(body));
    }

    public ApiResponse<LearningAssignment> postLearningAssignmentsWithHttpInfo(LearningAssignmentCreate body) throws IOException {
        return this.postLearningAssignments(this.createPostLearningAssignmentsRequest(body).withHttpInfo());
    }

    private PostLearningAssignmentsRequest createPostLearningAssignmentsRequest(LearningAssignmentCreate body) {
        return PostLearningAssignmentsRequest.builder().withBody(body).build();
    }

    public LearningAssignment postLearningAssignments(PostLearningAssignmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignment> postLearningAssignments(ApiRequest<LearningAssignmentCreate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentAggregateResponse postLearningAssignmentsAggregatesQuery(LearningAssignmentAggregateParam body) throws IOException, ApiException {
        return this.postLearningAssignmentsAggregatesQuery(this.createPostLearningAssignmentsAggregatesQueryRequest(body));
    }

    public ApiResponse<LearningAssignmentAggregateResponse> postLearningAssignmentsAggregatesQueryWithHttpInfo(LearningAssignmentAggregateParam body) throws IOException {
        return this.postLearningAssignmentsAggregatesQuery(this.createPostLearningAssignmentsAggregatesQueryRequest(body).withHttpInfo());
    }

    private PostLearningAssignmentsAggregatesQueryRequest createPostLearningAssignmentsAggregatesQueryRequest(LearningAssignmentAggregateParam body) {
        return PostLearningAssignmentsAggregatesQueryRequest.builder().withBody(body).build();
    }

    public LearningAssignmentAggregateResponse postLearningAssignmentsAggregatesQuery(PostLearningAssignmentsAggregatesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentAggregateResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentAggregateResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentAggregateResponse> postLearningAssignmentsAggregatesQuery(ApiRequest<LearningAssignmentAggregateParam> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentAggregateResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentBulkAddResponse postLearningAssignmentsBulkadd(List<LearningAssignmentItem> body) throws IOException, ApiException {
        return this.postLearningAssignmentsBulkadd(this.createPostLearningAssignmentsBulkaddRequest(body));
    }

    public ApiResponse<LearningAssignmentBulkAddResponse> postLearningAssignmentsBulkaddWithHttpInfo(List<LearningAssignmentItem> body) throws IOException {
        return this.postLearningAssignmentsBulkadd(this.createPostLearningAssignmentsBulkaddRequest(body).withHttpInfo());
    }

    private PostLearningAssignmentsBulkaddRequest createPostLearningAssignmentsBulkaddRequest(List<LearningAssignmentItem> body) {
        return PostLearningAssignmentsBulkaddRequest.builder().withBody(body).build();
    }

    public LearningAssignmentBulkAddResponse postLearningAssignmentsBulkadd(PostLearningAssignmentsBulkaddRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentBulkAddResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentBulkAddResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentBulkAddResponse> postLearningAssignmentsBulkadd(ApiRequest<List<LearningAssignmentItem>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentBulkAddResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentBulkRemoveResponse postLearningAssignmentsBulkremove(List<String> body) throws IOException, ApiException {
        return this.postLearningAssignmentsBulkremove(this.createPostLearningAssignmentsBulkremoveRequest(body));
    }

    public ApiResponse<LearningAssignmentBulkRemoveResponse> postLearningAssignmentsBulkremoveWithHttpInfo(List<String> body) throws IOException {
        return this.postLearningAssignmentsBulkremove(this.createPostLearningAssignmentsBulkremoveRequest(body).withHttpInfo());
    }

    private PostLearningAssignmentsBulkremoveRequest createPostLearningAssignmentsBulkremoveRequest(List<String> body) {
        return PostLearningAssignmentsBulkremoveRequest.builder().withBody(body).build();
    }

    public LearningAssignmentBulkRemoveResponse postLearningAssignmentsBulkremove(PostLearningAssignmentsBulkremoveRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentBulkRemoveResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentBulkRemoveResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentBulkRemoveResponse> postLearningAssignmentsBulkremove(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentBulkRemoveResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModuleJobResponse postLearningModuleJobs(String moduleId, LearningModuleJobRequest body) throws IOException, ApiException {
        return this.postLearningModuleJobs(this.createPostLearningModuleJobsRequest(moduleId, body));
    }

    public ApiResponse<LearningModuleJobResponse> postLearningModuleJobsWithHttpInfo(String moduleId, LearningModuleJobRequest body) throws IOException {
        return this.postLearningModuleJobs(this.createPostLearningModuleJobsRequest(moduleId, body).withHttpInfo());
    }

    private PostLearningModuleJobsRequest createPostLearningModuleJobsRequest(String moduleId, LearningModuleJobRequest body) {
        return PostLearningModuleJobsRequest.builder().withModuleId(moduleId).withBody(body).build();
    }

    public LearningModuleJobResponse postLearningModuleJobs(PostLearningModuleJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModuleJobResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModuleJobResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModuleJobResponse> postLearningModuleJobs(ApiRequest<LearningModuleJobRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModuleJobResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModulePublishResponse postLearningModulePublish(String moduleId, LearningModulePublishRequest body) throws IOException, ApiException {
        return this.postLearningModulePublish(this.createPostLearningModulePublishRequest(moduleId, body));
    }

    public ApiResponse<LearningModulePublishResponse> postLearningModulePublishWithHttpInfo(String moduleId, LearningModulePublishRequest body) throws IOException {
        return this.postLearningModulePublish(this.createPostLearningModulePublishRequest(moduleId, body).withHttpInfo());
    }

    private PostLearningModulePublishRequest createPostLearningModulePublishRequest(String moduleId, LearningModulePublishRequest body) {
        return PostLearningModulePublishRequest.builder().withModuleId(moduleId).withBody(body).build();
    }

    public LearningModulePublishResponse postLearningModulePublish(PostLearningModulePublishRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModulePublishResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModulePublishResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModulePublishResponse> postLearningModulePublish(ApiRequest<LearningModulePublishRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModulePublishResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModule postLearningModules(LearningModuleRequest body) throws IOException, ApiException {
        return this.postLearningModules(this.createPostLearningModulesRequest(body));
    }

    public ApiResponse<LearningModule> postLearningModulesWithHttpInfo(LearningModuleRequest body) throws IOException {
        return this.postLearningModules(this.createPostLearningModulesRequest(body).withHttpInfo());
    }

    private PostLearningModulesRequest createPostLearningModulesRequest(LearningModuleRequest body) {
        return PostLearningModulesRequest.builder().withBody(body).build();
    }

    public LearningModule postLearningModules(PostLearningModulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModule> postLearningModules(ApiRequest<LearningModuleRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningAssignmentUserListing postLearningRulesQuery(Integer pageSize, Integer pageNumber, LearningAssignmentUserQuery body) throws IOException, ApiException {
        return this.postLearningRulesQuery(this.createPostLearningRulesQueryRequest(pageSize, pageNumber, body));
    }

    public ApiResponse<LearningAssignmentUserListing> postLearningRulesQueryWithHttpInfo(Integer pageSize, Integer pageNumber, LearningAssignmentUserQuery body) throws IOException {
        return this.postLearningRulesQuery(this.createPostLearningRulesQueryRequest(pageSize, pageNumber, body).withHttpInfo());
    }

    private PostLearningRulesQueryRequest createPostLearningRulesQueryRequest(Integer pageSize, Integer pageNumber, LearningAssignmentUserQuery body) {
        return PostLearningRulesQueryRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withBody(body).build();
    }

    public LearningAssignmentUserListing postLearningRulesQuery(PostLearningRulesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningAssignmentUserListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningAssignmentUserListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningAssignmentUserListing> postLearningRulesQuery(ApiRequest<LearningAssignmentUserQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningAssignmentUserListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningScheduleSlotsQueryResponse postLearningScheduleslotsQuery(LearningScheduleSlotsQueryRequest body) throws IOException, ApiException {
        return this.postLearningScheduleslotsQuery(this.createPostLearningScheduleslotsQueryRequest(body));
    }

    public ApiResponse<LearningScheduleSlotsQueryResponse> postLearningScheduleslotsQueryWithHttpInfo(LearningScheduleSlotsQueryRequest body) throws IOException {
        return this.postLearningScheduleslotsQuery(this.createPostLearningScheduleslotsQueryRequest(body).withHttpInfo());
    }

    private PostLearningScheduleslotsQueryRequest createPostLearningScheduleslotsQueryRequest(LearningScheduleSlotsQueryRequest body) {
        return PostLearningScheduleslotsQueryRequest.builder().withBody(body).build();
    }

    public LearningScheduleSlotsQueryResponse postLearningScheduleslotsQuery(PostLearningScheduleslotsQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningScheduleSlotsQueryResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningScheduleSlotsQueryResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningScheduleSlotsQueryResponse> postLearningScheduleslotsQuery(ApiRequest<LearningScheduleSlotsQueryRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningScheduleSlotsQueryResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModule putLearningModule(String moduleId, LearningModuleRequest body) throws IOException, ApiException {
        return this.putLearningModule(this.createPutLearningModuleRequest(moduleId, body));
    }

    public ApiResponse<LearningModule> putLearningModuleWithHttpInfo(String moduleId, LearningModuleRequest body) throws IOException {
        return this.putLearningModule(this.createPutLearningModuleRequest(moduleId, body).withHttpInfo());
    }

    private PutLearningModuleRequest createPutLearningModuleRequest(String moduleId, LearningModuleRequest body) {
        return PutLearningModuleRequest.builder().withModuleId(moduleId).withBody(body).build();
    }

    public LearningModule putLearningModule(PutLearningModuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModule> putLearningModule(ApiRequest<LearningModuleRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LearningModuleRule putLearningModuleRule(String moduleId, LearningModuleRule body) throws IOException, ApiException {
        return this.putLearningModuleRule(this.createPutLearningModuleRuleRequest(moduleId, body));
    }

    public ApiResponse<LearningModuleRule> putLearningModuleRuleWithHttpInfo(String moduleId, LearningModuleRule body) throws IOException {
        return this.putLearningModuleRule(this.createPutLearningModuleRuleRequest(moduleId, body).withHttpInfo());
    }

    private PutLearningModuleRuleRequest createPutLearningModuleRuleRequest(String moduleId, LearningModuleRule body) {
        return PutLearningModuleRuleRequest.builder().withModuleId(moduleId).withBody(body).build();
    }

    public LearningModuleRule putLearningModuleRule(PutLearningModuleRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LearningModuleRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LearningModuleRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LearningModuleRule> putLearningModuleRule(ApiRequest<LearningModuleRule> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LearningModuleRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

