/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetScimGroupsRequest {
    private Integer startIndex;
    private Integer count;
    private List<String> attributes;
    private List<String> excludedAttributes;
    private String filter;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public GetScimGroupsRequest withStartIndex(Integer startIndex) {
        this.setStartIndex(startIndex);
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public GetScimGroupsRequest withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public GetScimGroupsRequest withAttributes(List<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public void setExcludedAttributes(List<String> excludedAttributes) {
        this.excludedAttributes = excludedAttributes;
    }

    public GetScimGroupsRequest withExcludedAttributes(List<String> excludedAttributes) {
        this.setExcludedAttributes(excludedAttributes);
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public GetScimGroupsRequest withFilter(String filter) {
        this.setFilter(filter);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimGroupsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/scim/groups").withQueryParameters("startIndex", "", this.startIndex).withQueryParameters("count", "", this.count).withQueryParameters("attributes", "multi", this.attributes).withQueryParameters("excludedAttributes", "multi", this.excludedAttributes).withQueryParameters("filter", "", this.filter).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetScimGroupsRequest request = new GetScimGroupsRequest();

        private Builder() {
        }

        public Builder withStartIndex(Integer startIndex) {
            this.request.setStartIndex(startIndex);
            return this;
        }

        public Builder withCount(Integer count) {
            this.request.setCount(count);
            return this;
        }

        public Builder withAttributes(List<String> attributes) {
            this.request.setAttributes(attributes);
            return this;
        }

        public Builder withAttributesEnumValues(List<attributesValues> attributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (attributesValues e : attributes) {
                stringList.add(e.toString());
            }
            this.request.setAttributes(stringList);
            return this;
        }

        public Builder withExcludedAttributes(List<String> excludedAttributes) {
            this.request.setExcludedAttributes(excludedAttributes);
            return this;
        }

        public Builder withExcludedAttributesEnumValues(List<excludedAttributesValues> excludedAttributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (excludedAttributesValues e : excludedAttributes) {
                stringList.add(e.toString());
            }
            this.request.setExcludedAttributes(stringList);
            return this;
        }

        public Builder withFilter(String filter) {
            this.request.setFilter(filter);
            return this;
        }

        public GetScimGroupsRequest build() {
            return this.request;
        }
    }

    public static enum excludedAttributesValues {
        ID("id"),
        DISPLAYNAME("displayName"),
        MEMBERS("members"),
        EXTERNALID("externalId"),
        META("meta"),
        META_VERSION("meta.version"),
        META_LASTMODIFIED("meta.lastModified"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_ID("urn:ietf:params:scim:schemas:core:2.0:Group:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META("urn:ietf:params:scim:schemas:core:2.0:Group:meta"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META_VERSION("urn:ietf:params:scim:schemas:core:2.0:Group:meta.version"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META_LASTMODIFIED("urn:ietf:params:scim:schemas:core:2.0:Group:meta.lastModified"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:Group:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_MEMBERS("urn:ietf:params:scim:schemas:core:2.0:Group:members"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:Group:externalId");

        private String value;

        private excludedAttributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static excludedAttributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (excludedAttributesValues value : excludedAttributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return excludedAttributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum attributesValues {
        ID("id"),
        DISPLAYNAME("displayName"),
        MEMBERS("members"),
        EXTERNALID("externalId"),
        META("meta"),
        META_VERSION("meta.version"),
        META_LASTMODIFIED("meta.lastModified"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_ID("urn:ietf:params:scim:schemas:core:2.0:Group:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META("urn:ietf:params:scim:schemas:core:2.0:Group:meta"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META_VERSION("urn:ietf:params:scim:schemas:core:2.0:Group:meta.version"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_META_LASTMODIFIED("urn:ietf:params:scim:schemas:core:2.0:Group:meta.lastModified"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:Group:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_MEMBERS("urn:ietf:params:scim:schemas:core:2.0:Group:members"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:Group:externalId");

        private String value;

        private attributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static attributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (attributesValues value : attributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return attributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

