/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetLearningModulesAssignmentsRequest {
    private List<String> userIds;
    private Integer pageSize;
    private Integer pageNumber;
    private String searchTerm;
    private String overdue;
    private List<String> assignmentStates;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public GetLearningModulesAssignmentsRequest withUserIds(List<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetLearningModulesAssignmentsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetLearningModulesAssignmentsRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public GetLearningModulesAssignmentsRequest withSearchTerm(String searchTerm) {
        this.setSearchTerm(searchTerm);
        return this;
    }

    public String getOverdue() {
        return this.overdue;
    }

    public void setOverdue(String overdue) {
        this.overdue = overdue;
    }

    public GetLearningModulesAssignmentsRequest withOverdue(String overdue) {
        this.setOverdue(overdue);
        return this;
    }

    public List<String> getAssignmentStates() {
        return this.assignmentStates;
    }

    public void setAssignmentStates(List<String> assignmentStates) {
        this.assignmentStates = assignmentStates;
    }

    public GetLearningModulesAssignmentsRequest withAssignmentStates(List<String> assignmentStates) {
        this.setAssignmentStates(assignmentStates);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetLearningModulesAssignmentsRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLearningModulesAssignmentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userIds == null) {
            throw new IllegalStateException("Missing the required parameter 'userIds' when building request for GetLearningModulesAssignmentsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/learning/modules/assignments").withQueryParameters("userIds", "multi", this.userIds).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("searchTerm", "", this.searchTerm).withQueryParameters("overdue", "", this.overdue).withQueryParameters("assignmentStates", "multi", this.assignmentStates).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> userIds) {
        return new Builder().withRequiredParams(userIds);
    }

    public static class Builder {
        private final GetLearningModulesAssignmentsRequest request = new GetLearningModulesAssignmentsRequest();

        private Builder() {
        }

        public Builder withUserIds(List<String> userIds) {
            this.request.setUserIds(userIds);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withSearchTerm(String searchTerm) {
            this.request.setSearchTerm(searchTerm);
            return this;
        }

        public Builder withOverdue(String overdue) {
            this.request.setOverdue(overdue);
            return this;
        }

        public Builder withOverdue(overdueValues overdue) {
            this.request.setOverdue(overdue.toString());
            return this;
        }

        public Builder withAssignmentStates(List<String> assignmentStates) {
            this.request.setAssignmentStates(assignmentStates);
            return this;
        }

        public Builder withAssignmentStatesEnumValues(List<assignmentStatesValues> assignmentStates) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (assignmentStatesValues e : assignmentStates) {
                stringList.add(e.toString());
            }
            this.request.setAssignmentStates(stringList);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(List<String> userIds) {
            this.request.setUserIds(userIds);
            return this;
        }

        public GetLearningModulesAssignmentsRequest build() {
            if (this.request.userIds == null) {
                throw new IllegalStateException("Missing the required parameter 'userIds' when building request for GetLearningModulesAssignmentsRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        COVERART("coverArt");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum assignmentStatesValues {
        NOTASSIGNED("NotAssigned"),
        ASSIGNED("Assigned"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private assignmentStatesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static assignmentStatesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (assignmentStatesValues value : assignmentStatesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return assignmentStatesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum overdueValues {
        TRUE("True"),
        FALSE("False"),
        ANY("Any");

        private String value;

        private overdueValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static overdueValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (overdueValues value : overdueValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return overdueValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

