/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CampaignRule;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOutboundCampaignruleRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String campaignRuleId;
    private CampaignRule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCampaignRuleId() {
        return this.campaignRuleId;
    }

    public void setCampaignRuleId(String campaignRuleId) {
        this.campaignRuleId = campaignRuleId;
    }

    public PutOutboundCampaignruleRequest withCampaignRuleId(String campaignRuleId) {
        this.setCampaignRuleId(campaignRuleId);
        return this;
    }

    public CampaignRule getBody() {
        return this.body;
    }

    public void setBody(CampaignRule body) {
        this.body = body;
    }

    public PutOutboundCampaignruleRequest withBody(CampaignRule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundCampaignruleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CampaignRule> withHttpInfo() {
        if (this.campaignRuleId == null) {
            throw new IllegalStateException("Missing the required parameter 'campaignRuleId' when building request for PutOutboundCampaignruleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundCampaignruleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/campaignrules/{campaignRuleId}").withPathParameter("campaignRuleId", this.campaignRuleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String campaignRuleId, CampaignRule body) {
        return new Builder().withRequiredParams(campaignRuleId, body);
    }

    public static class Builder {
        private final PutOutboundCampaignruleRequest request = new PutOutboundCampaignruleRequest();

        private Builder() {
        }

        public Builder withCampaignRuleId(String campaignRuleId) {
            this.request.setCampaignRuleId(campaignRuleId);
            return this;
        }

        public Builder withBody(CampaignRule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String campaignRuleId, CampaignRule body) {
            this.request.setCampaignRuleId(campaignRuleId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundCampaignruleRequest build() {
            return this.request;
        }
    }
}

