/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserPresence;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchUserPresenceRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String userId;
    private String sourceId;
    private UserPresence body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserPresenceRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public PatchUserPresenceRequest withSourceId(String sourceId) {
        this.setSourceId(sourceId);
        return this;
    }

    public UserPresence getBody() {
        return this.body;
    }

    public void setBody(UserPresence body) {
        this.body = body;
    }

    public PatchUserPresenceRequest withBody(UserPresence body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserPresenceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserPresence> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserPresenceRequest.");
        }
        if (this.sourceId == null) {
            throw new IllegalStateException("Missing the required parameter 'sourceId' when building request for PatchUserPresenceRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserPresenceRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}/presences/{sourceId}").withPathParameter("userId", this.userId).withPathParameter("sourceId", this.sourceId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String sourceId, UserPresence body) {
        return new Builder().withRequiredParams(userId, sourceId, body);
    }

    public static class Builder {
        private final PatchUserPresenceRequest request = new PatchUserPresenceRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withSourceId(String sourceId) {
            this.request.setSourceId(sourceId);
            return this;
        }

        public Builder withBody(UserPresence body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String sourceId, UserPresence body) {
            this.request.setUserId(userId);
            this.request.setSourceId(sourceId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserPresenceRequest build() {
            return this.request;
        }
    }
}

