/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetLanguagesTranslationsBuiltinRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String language;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public GetLanguagesTranslationsBuiltinRequest withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLanguagesTranslationsBuiltinRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.language == null) {
            throw new IllegalStateException("Missing the required parameter 'language' when building request for GetLanguagesTranslationsBuiltinRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/languages/translations/builtin").withQueryParameters("language", "", this.language).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String language) {
        return new Builder().withRequiredParams(language);
    }

    public static class Builder {
        private final GetLanguagesTranslationsBuiltinRequest request = new GetLanguagesTranslationsBuiltinRequest();

        private Builder() {
        }

        public Builder withLanguage(String language) {
            this.request.setLanguage(language);
            return this;
        }

        public Builder withRequiredParams(String language) {
            this.request.setLanguage(language);
            return this;
        }

        public GetLanguagesTranslationsBuiltinRequest build() {
            return this.request;
        }
    }
}

