/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteConversationParticipantCodeRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String conversationId;
    private String participantId;
    private String addCommunicationCode;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public DeleteConversationParticipantCodeRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public DeleteConversationParticipantCodeRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public String getAddCommunicationCode() {
        return this.addCommunicationCode;
    }

    public void setAddCommunicationCode(String addCommunicationCode) {
        this.addCommunicationCode = addCommunicationCode;
    }

    public DeleteConversationParticipantCodeRequest withAddCommunicationCode(String addCommunicationCode) {
        this.setAddCommunicationCode(addCommunicationCode);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteConversationParticipantCodeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for DeleteConversationParticipantCodeRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for DeleteConversationParticipantCodeRequest.");
        }
        if (this.addCommunicationCode == null) {
            throw new IllegalStateException("Missing the required parameter 'addCommunicationCode' when building request for DeleteConversationParticipantCodeRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withPathParameter("addCommunicationCode", this.addCommunicationCode).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, String addCommunicationCode) {
        return new Builder().withRequiredParams(conversationId, participantId, addCommunicationCode);
    }

    public static class Builder {
        private final DeleteConversationParticipantCodeRequest request = new DeleteConversationParticipantCodeRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withAddCommunicationCode(String addCommunicationCode) {
            this.request.setAddCommunicationCode(addCommunicationCode);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, String addCommunicationCode) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setAddCommunicationCode(addCommunicationCode);
            return this;
        }

        public DeleteConversationParticipantCodeRequest build() {
            return this.request;
        }
    }
}

