/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteChatsUserMessageRequest {
    private String userId;
    private String messageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DeleteChatsUserMessageRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public DeleteChatsUserMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteChatsUserMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteChatsUserMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for DeleteChatsUserMessageRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/chats/users/{userId}/messages/{messageId}").withPathParameter("userId", this.userId).withPathParameter("messageId", this.messageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String messageId) {
        return new Builder().withRequiredParams(userId, messageId);
    }

    public static class Builder {
        private final DeleteChatsUserMessageRequest request = new DeleteChatsUserMessageRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withRequiredParams(String userId, String messageId) {
            this.request.setUserId(userId);
            this.request.setMessageId(messageId);
            return this;
        }

        public DeleteChatsUserMessageRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteChatsUserMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for DeleteChatsUserMessageRequest.");
            }
            return this.request;
        }
    }
}

