/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ExternalMetricDefinitionUpdateRequest
implements Serializable {
    private String name = null;
    private Integer precision = null;
    private DefaultObjectiveTypeEnum defaultObjectiveType = null;
    private Boolean enabled = null;

    public ExternalMetricDefinitionUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the External Metric Definition")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalMetricDefinitionUpdateRequest precision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @ApiModelProperty(example="null", value="The decimal precision of the External Metric Definition. Must be at least 0 and at most 5")
    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public ExternalMetricDefinitionUpdateRequest defaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
        return this;
    }

    @ApiModelProperty(example="null", value="The default objective type of the External Metric Definition")
    @JsonProperty(value="defaultObjectiveType")
    public DefaultObjectiveTypeEnum getDefaultObjectiveType() {
        return this.defaultObjectiveType;
    }

    public void setDefaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
    }

    public ExternalMetricDefinitionUpdateRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the External Metric Definition is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricDefinitionUpdateRequest externalMetricDefinitionUpdateRequest = (ExternalMetricDefinitionUpdateRequest)o;
        return Objects.equals(this.name, externalMetricDefinitionUpdateRequest.name) && Objects.equals(this.precision, externalMetricDefinitionUpdateRequest.precision) && Objects.equals((Object)this.defaultObjectiveType, (Object)externalMetricDefinitionUpdateRequest.defaultObjectiveType) && Objects.equals(this.enabled, externalMetricDefinitionUpdateRequest.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.precision, this.defaultObjectiveType, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalMetricDefinitionUpdateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    defaultObjectiveType: ").append(this.toIndentedString((Object)this.defaultObjectiveType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DefaultObjectiveTypeEnumDeserializer.class)
    public static enum DefaultObjectiveTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIGHERISBETTER("HigherIsBetter"),
        LOWERISBETTER("LowerIsBetter"),
        TARGETAREA("TargetArea");

        private String value;

        private DefaultObjectiveTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DefaultObjectiveTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DefaultObjectiveTypeEnum value : DefaultObjectiveTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DefaultObjectiveTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DefaultObjectiveTypeEnumDeserializer
    extends StdDeserializer<DefaultObjectiveTypeEnum> {
        public DefaultObjectiveTypeEnumDeserializer() {
            super(DefaultObjectiveTypeEnumDeserializer.class);
        }

        public DefaultObjectiveTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DefaultObjectiveTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

