/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SmsPhoneNumber;
import java.util.HashMap;
import java.util.Map;

public class PutRoutingSmsPhonenumberRequest {
    private String addressId;
    private SmsPhoneNumber body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAddressId() {
        return this.addressId;
    }

    public void setAddressId(String addressId) {
        this.addressId = addressId;
    }

    public PutRoutingSmsPhonenumberRequest withAddressId(String addressId) {
        this.setAddressId(addressId);
        return this;
    }

    public SmsPhoneNumber getBody() {
        return this.body;
    }

    public void setBody(SmsPhoneNumber body) {
        this.body = body;
    }

    public PutRoutingSmsPhonenumberRequest withBody(SmsPhoneNumber body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingSmsPhonenumberRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SmsPhoneNumber> withHttpInfo() {
        if (this.addressId == null) {
            throw new IllegalStateException("Missing the required parameter 'addressId' when building request for PutRoutingSmsPhonenumberRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSmsPhonenumberRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/sms/phonenumbers/{addressId}").withPathParameter("addressId", this.addressId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String addressId, SmsPhoneNumber body) {
        return new Builder().withRequiredParams(addressId, body);
    }

    public static class Builder {
        private final PutRoutingSmsPhonenumberRequest request = new PutRoutingSmsPhonenumberRequest();

        private Builder() {
        }

        public Builder withAddressId(String addressId) {
            this.request.setAddressId(addressId);
            return this;
        }

        public Builder withBody(SmsPhoneNumber body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String addressId, SmsPhoneNumber body) {
            this.request.setAddressId(addressId);
            this.request.setBody(body);
            return this;
        }

        public PutRoutingSmsPhonenumberRequest build() {
            if (this.request.addressId == null) {
                throw new IllegalStateException("Missing the required parameter 'addressId' when building request for PutRoutingSmsPhonenumberRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSmsPhonenumberRequest.");
            }
            return this.request;
        }
    }
}

