/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.TransferToAgentRequest;
import java.util.HashMap;
import java.util.Map;

public class PostConversationParticipantReplaceAgentRequest {
    private String conversationId;
    private String participantId;
    private TransferToAgentRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationParticipantReplaceAgentRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PostConversationParticipantReplaceAgentRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public TransferToAgentRequest getBody() {
        return this.body;
    }

    public void setBody(TransferToAgentRequest body) {
        this.body = body;
    }

    public PostConversationParticipantReplaceAgentRequest withBody(TransferToAgentRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationParticipantReplaceAgentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<TransferToAgentRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationParticipantReplaceAgentRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationParticipantReplaceAgentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationParticipantReplaceAgentRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/{conversationId}/participants/{participantId}/replace/agent").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, TransferToAgentRequest body) {
        return new Builder().withRequiredParams(conversationId, participantId, body);
    }

    public static class Builder {
        private final PostConversationParticipantReplaceAgentRequest request = new PostConversationParticipantReplaceAgentRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(TransferToAgentRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, TransferToAgentRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationParticipantReplaceAgentRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationParticipantReplaceAgentRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationParticipantReplaceAgentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationParticipantReplaceAgentRequest.");
            }
            return this.request;
        }
    }
}

