/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationsMessageMessageRequest {
    private String conversationId;
    private String messageId;
    private Boolean useNormalizedMessage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationsMessageMessageRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public GetConversationsMessageMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public Boolean getUseNormalizedMessage() {
        return this.useNormalizedMessage;
    }

    public void setUseNormalizedMessage(Boolean useNormalizedMessage) {
        this.useNormalizedMessage = useNormalizedMessage;
    }

    public GetConversationsMessageMessageRequest withUseNormalizedMessage(Boolean useNormalizedMessage) {
        this.setUseNormalizedMessage(useNormalizedMessage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsMessageMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationsMessageMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetConversationsMessageMessageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/messages/{conversationId}/messages/{messageId}").withPathParameter("conversationId", this.conversationId).withPathParameter("messageId", this.messageId).withQueryParameters("useNormalizedMessage", "", this.useNormalizedMessage).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String messageId) {
        return new Builder().withRequiredParams(conversationId, messageId);
    }

    public static class Builder {
        private final GetConversationsMessageMessageRequest request = new GetConversationsMessageMessageRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withUseNormalizedMessage(Boolean useNormalizedMessage) {
            this.request.setUseNormalizedMessage(useNormalizedMessage);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String messageId) {
            this.request.setConversationId(conversationId);
            this.request.setMessageId(messageId);
            return this;
        }

        public GetConversationsMessageMessageRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationsMessageMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetConversationsMessageMessageRequest.");
            }
            return this.request;
        }
    }
}

