/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentView;
import java.util.HashMap;
import java.util.Map;

public class PostKnowledgeKnowledgebaseDocumentViewsRequest {
    private String knowledgeBaseId;
    private String documentId;
    private KnowledgeDocumentView body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PostKnowledgeKnowledgebaseDocumentViewsRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PostKnowledgeKnowledgebaseDocumentViewsRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public KnowledgeDocumentView getBody() {
        return this.body;
    }

    public void setBody(KnowledgeDocumentView body) {
        this.body = body;
    }

    public PostKnowledgeKnowledgebaseDocumentViewsRequest withBody(KnowledgeDocumentView body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostKnowledgeKnowledgebaseDocumentViewsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeDocumentView> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseDocumentViewsRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeKnowledgebaseDocumentViewsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/documents/{documentId}/views").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("documentId", this.documentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String documentId) {
        return new Builder().withRequiredParams(knowledgeBaseId, documentId);
    }

    public static class Builder {
        private final PostKnowledgeKnowledgebaseDocumentViewsRequest request = new PostKnowledgeKnowledgebaseDocumentViewsRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(KnowledgeDocumentView body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String documentId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setDocumentId(documentId);
            return this;
        }

        public PostKnowledgeKnowledgebaseDocumentViewsRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseDocumentViewsRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeKnowledgebaseDocumentViewsRequest.");
            }
            return this.request;
        }
    }
}

