/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetTextbotsBotsSearchRequest {
    private List<String> botType;
    private String botName;
    private List<String> botId;
    private Integer pageSize;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public List<String> getBotType() {
        return this.botType;
    }

    public void setBotType(List<String> botType) {
        this.botType = botType;
    }

    public GetTextbotsBotsSearchRequest withBotType(List<String> botType) {
        this.setBotType(botType);
        return this;
    }

    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String botName) {
        this.botName = botName;
    }

    public GetTextbotsBotsSearchRequest withBotName(String botName) {
        this.setBotName(botName);
        return this;
    }

    public List<String> getBotId() {
        return this.botId;
    }

    public void setBotId(List<String> botId) {
        this.botId = botId;
    }

    public GetTextbotsBotsSearchRequest withBotId(List<String> botId) {
        this.setBotId(botId);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetTextbotsBotsSearchRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetTextbotsBotsSearchRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/textbots/bots/search").withQueryParameters("botType", "multi", this.botType).withQueryParameters("botName", "", this.botName).withQueryParameters("botId", "multi", this.botId).withQueryParameters("pageSize", "", this.pageSize).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetTextbotsBotsSearchRequest request = new GetTextbotsBotsSearchRequest();

        private Builder() {
        }

        public Builder withBotType(List<String> botType) {
            this.request.setBotType(botType);
            return this;
        }

        public Builder withBotTypeEnumValues(List<botTypeValues> botType) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (botTypeValues e : botType) {
                stringList.add(e.toString());
            }
            this.request.setBotType(stringList);
            return this;
        }

        public Builder withBotName(String botName) {
            this.request.setBotName(botName);
            return this;
        }

        public Builder withBotId(List<String> botId) {
            this.request.setBotId(botId);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public GetTextbotsBotsSearchRequest build() {
            return this.request;
        }
    }

    public static enum botTypeValues {
        GENESYSBOTCONNECTOR("GenesysBotConnector"),
        GENESYSDIALOGENGINE("GenesysDialogEngine"),
        AMAZONLEX("AmazonLex"),
        GOOGLEDIALOGFLOWES("GoogleDialogFlowES"),
        GOOGLEDIALOGFLOWCX("GoogleDialogFlowCX"),
        NUANCEDLG("NuanceDlg"),
        GENESYSBOTFLOW("GenesysBotFlow");

        private String value;

        private botTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static botTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (botTypeValues value : botTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return botTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

