/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ObjectiveZone;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Objective
implements Serializable {
    private String id = null;
    private String templateId = null;
    private List<ObjectiveZone> zones = new ArrayList<ObjectiveZone>();
    private Boolean enabled = null;
    private List<MediaTypesEnum> mediaTypes = new ArrayList<MediaTypesEnum>();
    private List<AddressableEntityRef> queues = new ArrayList<AddressableEntityRef>();
    private List<AddressableEntityRef> topics = new ArrayList<AddressableEntityRef>();
    private TopicIdsFilterTypeEnum topicIdsFilterType = null;
    private List<String> evaluationFormContextIds = new ArrayList<String>();
    private LocalDate dateStart = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Objective templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of this objective's base template")
    @JsonProperty(value="templateId")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Objective zones(List<ObjectiveZone> zones) {
        this.zones = zones;
        return this;
    }

    @ApiModelProperty(example="null", value="Objective zone specifies min,max points and values for the associated metric")
    @JsonProperty(value="zones")
    public List<ObjectiveZone> getZones() {
        return this.zones;
    }

    public void setZones(List<ObjectiveZone> zones) {
        this.zones = zones;
    }

    public Objective enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="A flag for whether this objective is enabled for the related metric")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Objective mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of media types for the metric")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public Objective queues(List<AddressableEntityRef> queues) {
        this.queues = queues;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of queues for the metric")
    @JsonProperty(value="queues")
    public List<AddressableEntityRef> getQueues() {
        return this.queues;
    }

    public void setQueues(List<AddressableEntityRef> queues) {
        this.queues = queues;
    }

    public Objective topics(List<AddressableEntityRef> topics) {
        this.topics = topics;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of topic ids for detected topic metrics")
    @JsonProperty(value="topics")
    public List<AddressableEntityRef> getTopics() {
        return this.topics;
    }

    public void setTopics(List<AddressableEntityRef> topics) {
        this.topics = topics;
    }

    public Objective topicIdsFilterType(TopicIdsFilterTypeEnum topicIdsFilterType) {
        this.topicIdsFilterType = topicIdsFilterType;
        return this;
    }

    @ApiModelProperty(example="null", value="A filter type for topic Ids. It's only used for objectives with topicIds. Default filter behavior is \"or\".")
    @JsonProperty(value="topicIdsFilterType")
    public TopicIdsFilterTypeEnum getTopicIdsFilterType() {
        return this.topicIdsFilterType;
    }

    public void setTopicIdsFilterType(TopicIdsFilterTypeEnum topicIdsFilterType) {
        this.topicIdsFilterType = topicIdsFilterType;
    }

    public Objective evaluationFormContextIds(List<String> evaluationFormContextIds) {
        this.evaluationFormContextIds = evaluationFormContextIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The ids of associated evaluation form context, for Quality Evaluation Score metrics")
    @JsonProperty(value="evaluationFormContextIds")
    public List<String> getEvaluationFormContextIds() {
        return this.evaluationFormContextIds;
    }

    public void setEvaluationFormContextIds(List<String> evaluationFormContextIds) {
        this.evaluationFormContextIds = evaluationFormContextIds;
    }

    public Objective dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="start date of the objective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Objective objective = (Objective)o;
        return Objects.equals(this.id, objective.id) && Objects.equals(this.templateId, objective.templateId) && Objects.equals(this.zones, objective.zones) && Objects.equals(this.enabled, objective.enabled) && Objects.equals(this.mediaTypes, objective.mediaTypes) && Objects.equals(this.queues, objective.queues) && Objects.equals(this.topics, objective.topics) && Objects.equals((Object)this.topicIdsFilterType, (Object)objective.topicIdsFilterType) && Objects.equals(this.evaluationFormContextIds, objective.evaluationFormContextIds) && Objects.equals(this.dateStart, objective.dateStart);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.templateId, this.zones, this.enabled, this.mediaTypes, this.queues, this.topics, this.topicIdsFilterType, this.evaluationFormContextIds, this.dateStart});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Objective {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    zones: ").append(this.toIndentedString(this.zones)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    topicIdsFilterType: ").append(this.toIndentedString((Object)this.topicIdsFilterType)).append("\n");
        sb.append("    evaluationFormContextIds: ").append(this.toIndentedString(this.evaluationFormContextIds)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TopicIdsFilterTypeEnumDeserializer.class)
    public static enum TopicIdsFilterTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AND("and"),
        OR("or");

        private String value;

        private TopicIdsFilterTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TopicIdsFilterTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TopicIdsFilterTypeEnum value : TopicIdsFilterTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TopicIdsFilterTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TopicIdsFilterTypeEnumDeserializer
    extends StdDeserializer<TopicIdsFilterTypeEnum> {
        public TopicIdsFilterTypeEnumDeserializer() {
            super(TopicIdsFilterTypeEnumDeserializer.class);
        }

        public TopicIdsFilterTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TopicIdsFilterTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        CALLBACK("callback"),
        CHAT("chat"),
        COBROWSE("cobrowse"),
        EMAIL("email"),
        MESSAGE("message"),
        SCREENSHARE("screenshare"),
        UNKNOWN("unknown"),
        VIDEO("video"),
        VOICE("voice");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

