/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetOutboundRulesetRequest {
    private String ruleSetId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleSetId() {
        return this.ruleSetId;
    }

    public void setRuleSetId(String ruleSetId) {
        this.ruleSetId = ruleSetId;
    }

    public GetOutboundRulesetRequest withRuleSetId(String ruleSetId) {
        this.setRuleSetId(ruleSetId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOutboundRulesetRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.ruleSetId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleSetId' when building request for GetOutboundRulesetRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/outbound/rulesets/{ruleSetId}").withPathParameter("ruleSetId", this.ruleSetId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleSetId) {
        return new Builder().withRequiredParams(ruleSetId);
    }

    public static class Builder {
        private final GetOutboundRulesetRequest request = new GetOutboundRulesetRequest();

        private Builder() {
        }

        public Builder withRuleSetId(String ruleSetId) {
            this.request.setRuleSetId(ruleSetId);
            return this;
        }

        public Builder withRequiredParams(String ruleSetId) {
            this.request.setRuleSetId(ruleSetId);
            return this;
        }

        public GetOutboundRulesetRequest build() {
            if (this.request.ruleSetId == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleSetId' when building request for GetOutboundRulesetRequest.");
            }
            return this.request;
        }
    }
}

