/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetDownloadRequest {
    private String downloadId;
    private String contentDisposition;
    private Boolean issueRedirect;
    private Boolean redirectToAuth;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDownloadId() {
        return this.downloadId;
    }

    public void setDownloadId(String downloadId) {
        this.downloadId = downloadId;
    }

    public GetDownloadRequest withDownloadId(String downloadId) {
        this.setDownloadId(downloadId);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public GetDownloadRequest withContentDisposition(String contentDisposition) {
        this.setContentDisposition(contentDisposition);
        return this;
    }

    public Boolean getIssueRedirect() {
        return this.issueRedirect;
    }

    public void setIssueRedirect(Boolean issueRedirect) {
        this.issueRedirect = issueRedirect;
    }

    public GetDownloadRequest withIssueRedirect(Boolean issueRedirect) {
        this.setIssueRedirect(issueRedirect);
        return this;
    }

    public Boolean getRedirectToAuth() {
        return this.redirectToAuth;
    }

    public void setRedirectToAuth(Boolean redirectToAuth) {
        this.redirectToAuth = redirectToAuth;
    }

    public GetDownloadRequest withRedirectToAuth(Boolean redirectToAuth) {
        this.setRedirectToAuth(redirectToAuth);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetDownloadRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.downloadId == null) {
            throw new IllegalStateException("Missing the required parameter 'downloadId' when building request for GetDownloadRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/downloads/{downloadId}").withPathParameter("downloadId", this.downloadId).withQueryParameters("contentDisposition", "", this.contentDisposition).withQueryParameters("issueRedirect", "", this.issueRedirect).withQueryParameters("redirectToAuth", "", this.redirectToAuth).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String downloadId) {
        return new Builder().withRequiredParams(downloadId);
    }

    public static class Builder {
        private final GetDownloadRequest request = new GetDownloadRequest();

        private Builder() {
        }

        public Builder withDownloadId(String downloadId) {
            this.request.setDownloadId(downloadId);
            return this;
        }

        public Builder withContentDisposition(String contentDisposition) {
            this.request.setContentDisposition(contentDisposition);
            return this;
        }

        public Builder withIssueRedirect(Boolean issueRedirect) {
            this.request.setIssueRedirect(issueRedirect);
            return this;
        }

        public Builder withRedirectToAuth(Boolean redirectToAuth) {
            this.request.setRedirectToAuth(redirectToAuth);
            return this;
        }

        public Builder withRequiredParams(String downloadId) {
            this.request.setDownloadId(downloadId);
            return this;
        }

        public GetDownloadRequest build() {
            if (this.request.downloadId == null) {
                throw new IllegalStateException("Missing the required parameter 'downloadId' when building request for GetDownloadRequest.");
            }
            return this.request;
        }
    }
}

