/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ScimV2User;
import java.util.HashMap;
import java.util.Map;

public class PutScimUserRequest {
    private String userId;
    private ScimV2User body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutScimUserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public ScimV2User getBody() {
        return this.body;
    }

    public void setBody(ScimV2User body) {
        this.body = body;
    }

    public PutScimUserRequest withBody(ScimV2User body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PutScimUserRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutScimUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ScimV2User> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutScimUserRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimUserRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/scim/users/{userId}").withPathParameter("userId", this.userId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, ScimV2User body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PutScimUserRequest request = new PutScimUserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(ScimV2User body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String userId, ScimV2User body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PutScimUserRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutScimUserRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimUserRequest.");
            }
            return this.request;
        }
    }
}

