/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DefaultGreetingList;
import java.util.HashMap;
import java.util.Map;

public class PutUserGreetingsDefaultsRequest {
    private String userId;
    private DefaultGreetingList body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutUserGreetingsDefaultsRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public DefaultGreetingList getBody() {
        return this.body;
    }

    public void setBody(DefaultGreetingList body) {
        this.body = body;
    }

    public PutUserGreetingsDefaultsRequest withBody(DefaultGreetingList body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserGreetingsDefaultsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DefaultGreetingList> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserGreetingsDefaultsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserGreetingsDefaultsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/users/{userId}/greetings/defaults").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, DefaultGreetingList body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PutUserGreetingsDefaultsRequest request = new PutUserGreetingsDefaultsRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(DefaultGreetingList body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, DefaultGreetingList body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PutUserGreetingsDefaultsRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserGreetingsDefaultsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserGreetingsDefaultsRequest.");
            }
            return this.request;
        }
    }
}

