/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class PredictorModelRetrainingError
implements Serializable {
    private String id = null;
    private ErrorCodeEnum errorCode = null;
    private Date dateOfFirstOccurrence = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", required=true, value="Error code describing model training failure.")
    @JsonProperty(value="errorCode")
    public ErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    @ApiModelProperty(example="null", required=true, value="Date when the first retraining failure happened. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateOfFirstOccurrence")
    public Date getDateOfFirstOccurrence() {
        return this.dateOfFirstOccurrence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictorModelRetrainingError predictorModelRetrainingError = (PredictorModelRetrainingError)o;
        return Objects.equals(this.id, predictorModelRetrainingError.id) && Objects.equals((Object)this.errorCode, (Object)predictorModelRetrainingError.errorCode) && Objects.equals(this.dateOfFirstOccurrence, predictorModelRetrainingError.dateOfFirstOccurrence);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.errorCode, this.dateOfFirstOccurrence});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PredictorModelRetrainingError {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    dateOfFirstOccurrence: ").append(this.toIndentedString(this.dateOfFirstOccurrence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ErrorCodeEnumDeserializer.class)
    public static enum ErrorCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOTENOUGHDATA("NotEnoughData"),
        SERVICEERROR("ServiceError"),
        UNKNOWNERROR("UnknownError");

        private String value;

        private ErrorCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ErrorCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ErrorCodeEnum value : ErrorCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ErrorCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ErrorCodeEnumDeserializer
    extends StdDeserializer<ErrorCodeEnum> {
        public ErrorCodeEnumDeserializer() {
            super(ErrorCodeEnumDeserializer.class);
        }

        public ErrorCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ErrorCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

