/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.BaseMediaSettings;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class MediaSettings
implements Serializable {
    private Boolean enableAutoAnswer = null;
    private Integer alertingTimeoutSeconds = null;
    private ServiceLevel serviceLevel = null;
    private Map<String, BaseMediaSettings> subTypeSettings = null;

    public MediaSettings enableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if auto-answer is enabled for the given media type or subtype (default is false).  Subtype settings take precedence over media type settings.")
    @JsonProperty(value="enableAutoAnswer")
    public Boolean getEnableAutoAnswer() {
        return this.enableAutoAnswer;
    }

    public void setEnableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
    }

    public MediaSettings alertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="alertingTimeoutSeconds")
    public Integer getAlertingTimeoutSeconds() {
        return this.alertingTimeoutSeconds;
    }

    public void setAlertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
    }

    public MediaSettings serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public MediaSettings subTypeSettings(Map<String, BaseMediaSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of media subtype to media subtype specific settings.")
    @JsonProperty(value="subTypeSettings")
    public Map<String, BaseMediaSettings> getSubTypeSettings() {
        return this.subTypeSettings;
    }

    public void setSubTypeSettings(Map<String, BaseMediaSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaSettings mediaSettings = (MediaSettings)o;
        return Objects.equals(this.enableAutoAnswer, mediaSettings.enableAutoAnswer) && Objects.equals(this.alertingTimeoutSeconds, mediaSettings.alertingTimeoutSeconds) && Objects.equals(this.serviceLevel, mediaSettings.serviceLevel) && Objects.equals(this.subTypeSettings, mediaSettings.subTypeSettings);
    }

    public int hashCode() {
        return Objects.hash(this.enableAutoAnswer, this.alertingTimeoutSeconds, this.serviceLevel, this.subTypeSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaSettings {\n");
        sb.append("    enableAutoAnswer: ").append(this.toIndentedString(this.enableAutoAnswer)).append("\n");
        sb.append("    alertingTimeoutSeconds: ").append(this.toIndentedString(this.alertingTimeoutSeconds)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    subTypeSettings: ").append(this.toIndentedString(this.subTypeSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

