/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.WorkitemScoredAgentRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkitemCreate
implements Serializable {
    private String name = null;
    private Integer priority = null;
    private Date dateDue = null;
    private Date dateExpires = null;
    private Integer durationSeconds = null;
    private Integer ttl = null;
    private String statusId = null;
    private String workbinId = null;
    private Boolean autoStatusTransition = null;
    private String description = null;
    private String typeId = null;
    private Map<String, Object> customFields = null;
    private String queueId = null;
    private String assigneeId = null;
    private String wrapupCode = null;
    private List<WorkitemScoredAgentRequest> scoredAgents = new ArrayList<WorkitemScoredAgentRequest>();
    private String languageId = null;
    private String externalContactId = null;
    private String externalTag = null;
    private List<String> skillIds = new ArrayList<String>();
    private List<String> preferredAgentIds = new ArrayList<String>();

    public WorkitemCreate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Workitem. Valid length between 3 and 256 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemCreate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public WorkitemCreate dateDue(Date dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @ApiModelProperty(example="null", value="The due date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDue")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public WorkitemCreate dateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiry date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    public void setDateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
    }

    public WorkitemCreate durationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The estimated duration in seconds to complete the Workitem. Maximum of 365 days.")
    @JsonProperty(value="durationSeconds")
    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public WorkitemCreate ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @ApiModelProperty(example="null", value="A timestamp specifying the time to live for the Workitem. Can not be greater than 365 days from the current time.")
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public WorkitemCreate statusId(String statusId) {
        this.statusId = statusId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Status of the Workitem.")
    @JsonProperty(value="statusId")
    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public WorkitemCreate workbinId(String workbinId) {
        this.workbinId = workbinId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of Workbin that contains the Workitem.")
    @JsonProperty(value="workbinId")
    public String getWorkbinId() {
        return this.workbinId;
    }

    public void setWorkbinId(String workbinId) {
        this.workbinId = workbinId;
    }

    public WorkitemCreate autoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
        return this;
    }

    @ApiModelProperty(example="null", value="Set it to false to disable auto status transition. By default, it is enabled.")
    @JsonProperty(value="autoStatusTransition")
    public Boolean getAutoStatusTransition() {
        return this.autoStatusTransition;
    }

    public void setAutoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
    }

    public WorkitemCreate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Workitem. Maximum length of 4096 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemCreate typeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the Worktype of the Workitem.")
    @JsonProperty(value="typeId")
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public WorkitemCreate customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom fields defined in the schema referenced by the Workitems Worktype.")
    @JsonProperty(value="customFields")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public WorkitemCreate queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Workitems queue. Must be a valid UUID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public WorkitemCreate assigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the assignee of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="assigneeId")
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    public WorkitemCreate wrapupCode(String wrapupCode) {
        this.wrapupCode = wrapupCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the wrapup. Must be a valid UUID.")
    @JsonProperty(value="wrapupCode")
    public String getWrapupCode() {
        return this.wrapupCode;
    }

    public void setWrapupCode(String wrapupCode) {
        this.wrapupCode = wrapupCode;
    }

    public WorkitemCreate scoredAgents(List<WorkitemScoredAgentRequest> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of scored agents for the Workitem. A workitem can have a maximum of 20 scored agents.")
    @JsonProperty(value="scoredAgents")
    public List<WorkitemScoredAgentRequest> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<WorkitemScoredAgentRequest> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public WorkitemCreate languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of language of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public WorkitemCreate externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the external contact of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public WorkitemCreate externalTag(String externalTag) {
        this.externalTag = externalTag;
        return this;
    }

    @ApiModelProperty(example="null", value="The external tag of the Workitem.")
    @JsonProperty(value="externalTag")
    public String getExternalTag() {
        return this.externalTag;
    }

    public void setExternalTag(String externalTag) {
        this.externalTag = externalTag;
    }

    public WorkitemCreate skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The skill IDs of the Workitem. Must be valid UUIDs.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public WorkitemCreate preferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The preferred agent IDs of the Workitem. Must be valid UUIDs.")
    @JsonProperty(value="preferredAgentIds")
    public List<String> getPreferredAgentIds() {
        return this.preferredAgentIds;
    }

    public void setPreferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemCreate workitemCreate = (WorkitemCreate)o;
        return Objects.equals(this.name, workitemCreate.name) && Objects.equals(this.priority, workitemCreate.priority) && Objects.equals(this.dateDue, workitemCreate.dateDue) && Objects.equals(this.dateExpires, workitemCreate.dateExpires) && Objects.equals(this.durationSeconds, workitemCreate.durationSeconds) && Objects.equals(this.ttl, workitemCreate.ttl) && Objects.equals(this.statusId, workitemCreate.statusId) && Objects.equals(this.workbinId, workitemCreate.workbinId) && Objects.equals(this.autoStatusTransition, workitemCreate.autoStatusTransition) && Objects.equals(this.description, workitemCreate.description) && Objects.equals(this.typeId, workitemCreate.typeId) && Objects.equals(this.customFields, workitemCreate.customFields) && Objects.equals(this.queueId, workitemCreate.queueId) && Objects.equals(this.assigneeId, workitemCreate.assigneeId) && Objects.equals(this.wrapupCode, workitemCreate.wrapupCode) && Objects.equals(this.scoredAgents, workitemCreate.scoredAgents) && Objects.equals(this.languageId, workitemCreate.languageId) && Objects.equals(this.externalContactId, workitemCreate.externalContactId) && Objects.equals(this.externalTag, workitemCreate.externalTag) && Objects.equals(this.skillIds, workitemCreate.skillIds) && Objects.equals(this.preferredAgentIds, workitemCreate.preferredAgentIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priority, this.dateDue, this.dateExpires, this.durationSeconds, this.ttl, this.statusId, this.workbinId, this.autoStatusTransition, this.description, this.typeId, this.customFields, this.queueId, this.assigneeId, this.wrapupCode, this.scoredAgents, this.languageId, this.externalContactId, this.externalTag, this.skillIds, this.preferredAgentIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    dateDue: ").append(this.toIndentedString(this.dateDue)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    durationSeconds: ").append(this.toIndentedString(this.durationSeconds)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    statusId: ").append(this.toIndentedString(this.statusId)).append("\n");
        sb.append("    workbinId: ").append(this.toIndentedString(this.workbinId)).append("\n");
        sb.append("    autoStatusTransition: ").append(this.toIndentedString(this.autoStatusTransition)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    wrapupCode: ").append(this.toIndentedString(this.wrapupCode)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    externalTag: ").append(this.toIndentedString(this.externalTag)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    preferredAgentIds: ").append(this.toIndentedString(this.preferredAgentIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

