/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="This is the metadata of an executionData entry for a flow.")
public class FlowExecutionDataQueryResult
implements Serializable {
    private String id = null;
    private String name = null;
    private Date startDateTime = null;
    private Date endDateTime = null;
    private String flowId = null;
    private String flowVersion = null;
    private String conversationId = null;
    private FlowTypeEnum flowType = null;
    private String flowErrorReason = null;
    private String flowName = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FlowExecutionDataQueryResult name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowExecutionDataQueryResult startDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDateTime")
    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public FlowExecutionDataQueryResult endDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The end time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endDateTime")
    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    public FlowExecutionDataQueryResult flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the flow that was executed.")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public FlowExecutionDataQueryResult flowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the flow that was executed.")
    @JsonProperty(value="flowVersion")
    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public FlowExecutionDataQueryResult conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the conversation that executed this flow.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public FlowExecutionDataQueryResult flowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of flow.")
    @JsonProperty(value="flowType")
    public FlowTypeEnum getFlowType() {
        return this.flowType;
    }

    public void setFlowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
    }

    public FlowExecutionDataQueryResult flowErrorReason(String flowErrorReason) {
        this.flowErrorReason = flowErrorReason;
        return this;
    }

    @ApiModelProperty(example="null", value="If the flow errored out this is the reason.")
    @JsonProperty(value="flowErrorReason")
    public String getFlowErrorReason() {
        return this.flowErrorReason;
    }

    public void setFlowErrorReason(String flowErrorReason) {
        this.flowErrorReason = flowErrorReason;
    }

    public FlowExecutionDataQueryResult flowName(String flowName) {
        this.flowName = flowName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the flow.")
    @JsonProperty(value="flowName")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowExecutionDataQueryResult flowExecutionDataQueryResult = (FlowExecutionDataQueryResult)o;
        return Objects.equals(this.id, flowExecutionDataQueryResult.id) && Objects.equals(this.name, flowExecutionDataQueryResult.name) && Objects.equals(this.startDateTime, flowExecutionDataQueryResult.startDateTime) && Objects.equals(this.endDateTime, flowExecutionDataQueryResult.endDateTime) && Objects.equals(this.flowId, flowExecutionDataQueryResult.flowId) && Objects.equals(this.flowVersion, flowExecutionDataQueryResult.flowVersion) && Objects.equals(this.conversationId, flowExecutionDataQueryResult.conversationId) && Objects.equals((Object)this.flowType, (Object)flowExecutionDataQueryResult.flowType) && Objects.equals(this.flowErrorReason, flowExecutionDataQueryResult.flowErrorReason) && Objects.equals(this.flowName, flowExecutionDataQueryResult.flowName) && Objects.equals(this.selfUri, flowExecutionDataQueryResult.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.startDateTime, this.endDateTime, this.flowId, this.flowVersion, this.conversationId, this.flowType, this.flowErrorReason, this.flowName, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowExecutionDataQueryResult {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString(this.flowVersion)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    flowType: ").append(this.toIndentedString((Object)this.flowType)).append("\n");
        sb.append("    flowErrorReason: ").append(this.toIndentedString(this.flowErrorReason)).append("\n");
        sb.append("    flowName: ").append(this.toIndentedString(this.flowName)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FlowTypeEnumDeserializer.class)
    public static enum FlowTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("bot"),
        COMMONMODULE("commonmodule"),
        DIGITALBOT("digitalbot"),
        INBOUNDCALL("inboundcall"),
        INBOUNDCHAT("inboundchat"),
        INBOUNDEMAIL("inboundemail"),
        INBOUNDSHORTMESSAGE("inboundshortmessage"),
        INQUEUECALL("inqueuecall"),
        INQUEUESHORTMESSAGE("inqueueshortmessage"),
        INQUEUEEMAIL("inqueueemail"),
        OUTBOUNDCALL("outboundcall"),
        SECURECALL("securecall"),
        SURVEYINVITE("surveyinvite"),
        VOICE("voice"),
        VOICEMAIL("voicemail"),
        WORKFLOW("workflow"),
        WORKITEM("workitem");

        private String value;

        private FlowTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlowTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlowTypeEnum value : FlowTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlowTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlowTypeEnumDeserializer
    extends StdDeserializer<FlowTypeEnum> {
        public FlowTypeEnumDeserializer() {
            super(FlowTypeEnumDeserializer.class);
        }

        public FlowTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlowTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

