/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteTokenRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteTokensMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetTokensMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetTokensTimeoutRequest;
import com.mypurecloud.sdk.v2.api.request.HeadTokensMeRequest;
import com.mypurecloud.sdk.v2.api.request.PutTokensTimeoutRequest;
import com.mypurecloud.sdk.v2.model.IdleTokenTimeout;
import com.mypurecloud.sdk.v2.model.TokenInfo;
import java.io.IOException;

public class TokensApi {
    private final ApiClient pcapiClient;

    public TokensApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokensApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteToken(String userId) throws IOException, ApiException {
        this.deleteToken(this.createDeleteTokenRequest(userId));
    }

    public ApiResponse<Void> deleteTokenWithHttpInfo(String userId) throws IOException {
        return this.deleteToken(this.createDeleteTokenRequest(userId).withHttpInfo());
    }

    private DeleteTokenRequest createDeleteTokenRequest(String userId) {
        return DeleteTokenRequest.builder().withUserId(userId).build();
    }

    public void deleteToken(DeleteTokenRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteToken(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteTokensMe() throws IOException, ApiException {
        this.deleteTokensMe(this.createDeleteTokensMeRequest());
    }

    public ApiResponse<Void> deleteTokensMeWithHttpInfo() throws IOException {
        return this.deleteTokensMe(this.createDeleteTokensMeRequest().withHttpInfo());
    }

    private DeleteTokensMeRequest createDeleteTokensMeRequest() {
        return DeleteTokensMeRequest.builder().build();
    }

    public void deleteTokensMe(DeleteTokensMeRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteTokensMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TokenInfo getTokensMe() throws IOException, ApiException {
        return this.getTokensMe(this.createGetTokensMeRequest());
    }

    public ApiResponse<TokenInfo> getTokensMeWithHttpInfo() throws IOException {
        return this.getTokensMe(this.createGetTokensMeRequest().withHttpInfo());
    }

    private GetTokensMeRequest createGetTokensMeRequest() {
        return GetTokensMeRequest.builder().build();
    }

    public TokenInfo getTokensMe(GetTokensMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TokenInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TokenInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TokenInfo> getTokensMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TokenInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IdleTokenTimeout getTokensTimeout() throws IOException, ApiException {
        return this.getTokensTimeout(this.createGetTokensTimeoutRequest());
    }

    public ApiResponse<IdleTokenTimeout> getTokensTimeoutWithHttpInfo() throws IOException {
        return this.getTokensTimeout(this.createGetTokensTimeoutRequest().withHttpInfo());
    }

    private GetTokensTimeoutRequest createGetTokensTimeoutRequest() {
        return GetTokensTimeoutRequest.builder().build();
    }

    public IdleTokenTimeout getTokensTimeout(GetTokensTimeoutRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IdleTokenTimeout> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IdleTokenTimeout>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IdleTokenTimeout> getTokensTimeout(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IdleTokenTimeout>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void headTokensMe() throws IOException, ApiException {
        this.headTokensMe(this.createHeadTokensMeRequest());
    }

    public ApiResponse<Void> headTokensMeWithHttpInfo() throws IOException {
        return this.headTokensMe(this.createHeadTokensMeRequest().withHttpInfo());
    }

    private HeadTokensMeRequest createHeadTokensMeRequest() {
        return HeadTokensMeRequest.builder().build();
    }

    public void headTokensMe(HeadTokensMeRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> headTokensMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IdleTokenTimeout putTokensTimeout(IdleTokenTimeout body) throws IOException, ApiException {
        return this.putTokensTimeout(this.createPutTokensTimeoutRequest(body));
    }

    public ApiResponse<IdleTokenTimeout> putTokensTimeoutWithHttpInfo(IdleTokenTimeout body) throws IOException {
        return this.putTokensTimeout(this.createPutTokensTimeoutRequest(body).withHttpInfo());
    }

    private PutTokensTimeoutRequest createPutTokensTimeoutRequest(IdleTokenTimeout body) {
        return PutTokensTimeoutRequest.builder().withBody(body).build();
    }

    public IdleTokenTimeout putTokensTimeout(PutTokensTimeoutRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IdleTokenTimeout> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IdleTokenTimeout>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IdleTokenTimeout> putTokensTimeout(ApiRequest<IdleTokenTimeout> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IdleTokenTimeout>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

