/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Defines response components of the Action Request.")
public class RequestConfig
implements Serializable {
    private String requestUrlTemplate = null;
    private String requestTemplate = null;
    private String requestTemplateUri = null;
    private String requestType = null;
    private Map<String, String> headers = new HashMap<String, String>();

    public RequestConfig requestUrlTemplate(String requestUrlTemplate) {
        this.requestUrlTemplate = requestUrlTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="URL that may include placeholders for requests to 3rd party service")
    @JsonProperty(value="requestUrlTemplate")
    public String getRequestUrlTemplate() {
        return this.requestUrlTemplate;
    }

    public void setRequestUrlTemplate(String requestUrlTemplate) {
        this.requestUrlTemplate = requestUrlTemplate;
    }

    public RequestConfig requestTemplate(String requestTemplate) {
        this.requestTemplate = requestTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Velocity template to define request body sent to 3rd party service.")
    @JsonProperty(value="requestTemplate")
    public String getRequestTemplate() {
        return this.requestTemplate;
    }

    public void setRequestTemplate(String requestTemplate) {
        this.requestTemplate = requestTemplate;
    }

    public RequestConfig requestTemplateUri(String requestTemplateUri) {
        this.requestTemplateUri = requestTemplateUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI to retrieve requestTemplate")
    @JsonProperty(value="requestTemplateUri")
    public String getRequestTemplateUri() {
        return this.requestTemplateUri;
    }

    public void setRequestTemplateUri(String requestTemplateUri) {
        this.requestTemplateUri = requestTemplateUri;
    }

    public RequestConfig requestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    @ApiModelProperty(example="null", value="HTTP method to use for request")
    @JsonProperty(value="requestType")
    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public RequestConfig headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @ApiModelProperty(example="null", value="Headers to include in request in (Header Name, Value) pairs.")
    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestConfig requestConfig = (RequestConfig)o;
        return Objects.equals(this.requestUrlTemplate, requestConfig.requestUrlTemplate) && Objects.equals(this.requestTemplate, requestConfig.requestTemplate) && Objects.equals(this.requestTemplateUri, requestConfig.requestTemplateUri) && Objects.equals(this.requestType, requestConfig.requestType) && Objects.equals(this.headers, requestConfig.headers);
    }

    public int hashCode() {
        return Objects.hash(this.requestUrlTemplate, this.requestTemplate, this.requestTemplateUri, this.requestType, this.headers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestConfig {\n");
        sb.append("    requestUrlTemplate: ").append(this.toIndentedString(this.requestUrlTemplate)).append("\n");
        sb.append("    requestTemplate: ").append(this.toIndentedString(this.requestTemplate)).append("\n");
        sb.append("    requestTemplateUri: ").append(this.toIndentedString(this.requestTemplateUri)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

