/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class GenericEventAction
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private MediaTypeEnum mediaType = null;
    private String prompt = null;
    private String mediaAddress = null;
    private Date createdDate = null;

    public GenericEventAction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the action.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GenericEventAction state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Current state of the action (e.g. qualified, succeeded, errored).")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public GenericEventAction mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type used to deliver the action (e.g. email, webhook).")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public GenericEventAction prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @ApiModelProperty(example="null", value="Prompt of the action to be displayed/sent to the visitor.")
    @JsonProperty(value="prompt")
    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public GenericEventAction mediaAddress(String mediaAddress) {
        this.mediaAddress = mediaAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address of the media type used to deliver the action (e.g. email address, webhook URL).")
    @JsonProperty(value="mediaAddress")
    public String getMediaAddress() {
        return this.mediaAddress;
    }

    public void setMediaAddress(String mediaAddress) {
        this.mediaAddress = mediaAddress;
    }

    public GenericEventAction createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the action was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericEventAction genericEventAction = (GenericEventAction)o;
        return Objects.equals(this.id, genericEventAction.id) && Objects.equals((Object)this.state, (Object)genericEventAction.state) && Objects.equals((Object)this.mediaType, (Object)genericEventAction.mediaType) && Objects.equals(this.prompt, genericEventAction.prompt) && Objects.equals(this.mediaAddress, genericEventAction.mediaAddress) && Objects.equals(this.createdDate, genericEventAction.createdDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.mediaType, this.prompt, this.mediaAddress, this.createdDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenericEventAction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    prompt: ").append(this.toIndentedString(this.prompt)).append("\n");
        sb.append("    mediaAddress: ").append(this.toIndentedString(this.mediaAddress)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        TIMEDOUT("timedout"),
        ERRORED("errored"),
        IGNORED("ignored"),
        QUALIFIED("qualified"),
        OFFERED("offered"),
        STARTED("started"),
        ENGAGED("engaged"),
        QUALIFIEDOUTSIDESCHEDULE("qualifiedOutsideSchedule"),
        OFFEREDOUTSIDESCHEDULE("offeredOutsideSchedule"),
        ABANDONED("abandoned"),
        COMPLETED("completed"),
        FREQUENCYCAPREACHED("frequencyCapReached");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEBCHAT("webchat"),
        WEBMESSAGINGOFFER("webMessagingOffer"),
        CONTENTOFFER("contentOffer"),
        INTEGRATIONACTION("integrationAction"),
        ARCHITECTFLOW("architectFlow"),
        OPENACTION("openAction");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

