/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class GeneralProgramJobRequest
implements Serializable {
    private DialectEnum dialect = null;
    private ModeEnum mode = null;

    public GeneralProgramJobRequest dialect(DialectEnum dialect) {
        this.dialect = dialect;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The dialect of the topics to link with the general program, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard")
    @JsonProperty(value="dialect")
    public DialectEnum getDialect() {
        return this.dialect;
    }

    public void setDialect(DialectEnum dialect) {
        this.dialect = dialect;
    }

    public GeneralProgramJobRequest mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="The mode to use for the general program job, default value is Skip")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralProgramJobRequest generalProgramJobRequest = (GeneralProgramJobRequest)o;
        return Objects.equals((Object)this.dialect, (Object)generalProgramJobRequest.dialect) && Objects.equals((Object)this.mode, (Object)generalProgramJobRequest.mode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dialect, this.mode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneralProgramJobRequest {\n");
        sb.append("    dialect: ").append(this.toIndentedString((Object)this.dialect)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DialectEnumDeserializer.class)
    public static enum DialectEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AR_001("ar-001"),
        AR_AE("ar-AE"),
        AR_BH("ar-BH"),
        AR_EG("ar-EG"),
        AR_IL("ar-IL"),
        AR_SA("ar-SA"),
        AR_TN("ar-TN"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        EN_ZA("en-ZA"),
        ES_ES("es-ES"),
        ES_US("es-US"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NL_NL("nl-NL"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT");

        private String value;

        private DialectEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DialectEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DialectEnum value : DialectEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DialectEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SKIP("Skip"),
        MERGE("Merge");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DialectEnumDeserializer
    extends StdDeserializer<DialectEnum> {
        public DialectEnumDeserializer() {
            super(DialectEnumDeserializer.class);
        }

        public DialectEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DialectEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

