/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class PredictorSchedule
implements Serializable {
    private ScheduleTypeEnum scheduleType = null;
    private Date dateStarted = null;

    public PredictorSchedule scheduleType(ScheduleTypeEnum scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The predictor schedule type.")
    @JsonProperty(value="scheduleType")
    public ScheduleTypeEnum getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(ScheduleTypeEnum scheduleType) {
        this.scheduleType = scheduleType;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the predictor schedule was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStarted")
    public Date getDateStarted() {
        return this.dateStarted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictorSchedule predictorSchedule = (PredictorSchedule)o;
        return Objects.equals((Object)this.scheduleType, (Object)predictorSchedule.scheduleType) && Objects.equals(this.dateStarted, predictorSchedule.dateStarted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheduleType, this.dateStarted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PredictorSchedule {\n");
        sb.append("    scheduleType: ").append(this.toIndentedString((Object)this.scheduleType)).append("\n");
        sb.append("    dateStarted: ").append(this.toIndentedString(this.dateStarted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ScheduleTypeEnumDeserializer.class)
    public static enum ScheduleTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HOURONHOUROFF("HourOnHourOff"),
        ONGOINGVALUEMONITORING("OngoingValueMonitoring");

        private String value;

        private ScheduleTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScheduleTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScheduleTypeEnum value : ScheduleTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScheduleTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ScheduleTypeEnumDeserializer
    extends StdDeserializer<ScheduleTypeEnum> {
        public ScheduleTypeEnumDeserializer() {
            super(ScheduleTypeEnumDeserializer.class);
        }

        public ScheduleTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ScheduleTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

