/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class StatusChange
implements Serializable {
    private Date dateStatusChanged = null;
    private StatusEnum status = null;
    private PreviousStatusEnum previousStatus = null;
    private NamespaceEnum namespace = null;
    private String message = null;
    private RejectReasonEnum rejectReason = null;

    @ApiModelProperty(example="null", value="The date of this status change. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStatusChanged")
    public Date getDateStatusChanged() {
        return this.dateStatusChanged;
    }

    @ApiModelProperty(example="null", value="The status the change request transitioned to")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="The status the change request transitioned from")
    @JsonProperty(value="previousStatus")
    public PreviousStatusEnum getPreviousStatus() {
        return this.previousStatus;
    }

    @ApiModelProperty(example="null", value="The namespace for the status change")
    @JsonProperty(value="namespace")
    public NamespaceEnum getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(example="null", value="A short message describing the status change")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(example="null", value="The reason for rejecting the limit override request")
    @JsonProperty(value="rejectReason")
    public RejectReasonEnum getRejectReason() {
        return this.rejectReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusChange statusChange = (StatusChange)o;
        return Objects.equals(this.dateStatusChanged, statusChange.dateStatusChanged) && Objects.equals((Object)this.status, (Object)statusChange.status) && Objects.equals((Object)this.previousStatus, (Object)statusChange.previousStatus) && Objects.equals((Object)this.namespace, (Object)statusChange.namespace) && Objects.equals(this.message, statusChange.message) && Objects.equals((Object)this.rejectReason, (Object)statusChange.rejectReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateStatusChanged, this.status, this.previousStatus, this.namespace, this.message, this.rejectReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusChange {\n");
        sb.append("    dateStatusChanged: ").append(this.toIndentedString(this.dateStatusChanged)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    previousStatus: ").append(this.toIndentedString((Object)this.previousStatus)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString((Object)this.namespace)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    rejectReason: ").append(this.toIndentedString((Object)this.rejectReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPROVED("Approved"),
        REJECTED("Rejected"),
        ROLLBACK("Rollback"),
        PENDING("Pending"),
        OPEN("Open"),
        SECONDARYAPPROVALNAMESPACESADDED("SecondaryApprovalNamespacesAdded"),
        REVIEWERAPPROVED("ReviewerApproved"),
        REVIEWERREJECTED("ReviewerRejected"),
        REVIEWERROLLBACK("ReviewerRollback"),
        IMPLEMENTINGCHANGE("ImplementingChange"),
        CHANGEIMPLEMENTED("ChangeImplemented"),
        IMPLEMENTINGROLLBACK("ImplementingRollback"),
        ROLLBACKIMPLEMENTED("RollbackImplemented");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=PreviousStatusEnumDeserializer.class)
    public static enum PreviousStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPROVED("Approved"),
        REJECTED("Rejected"),
        ROLLBACK("Rollback"),
        PENDING("Pending"),
        OPEN("Open"),
        SECONDARYAPPROVALNAMESPACESADDED("SecondaryApprovalNamespacesAdded"),
        REVIEWERAPPROVED("ReviewerApproved"),
        REVIEWERREJECTED("ReviewerRejected"),
        REVIEWERROLLBACK("ReviewerRollback"),
        IMPLEMENTINGCHANGE("ImplementingChange"),
        CHANGEIMPLEMENTED("ChangeImplemented"),
        IMPLEMENTINGROLLBACK("ImplementingRollback"),
        ROLLBACKIMPLEMENTED("RollbackImplemented");

        private String value;

        private PreviousStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PreviousStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PreviousStatusEnum value : PreviousStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PreviousStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=NamespaceEnumDeserializer.class)
    public static enum NamespaceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENT_ASSISTANT("agent.assistant"),
        ANALYTICS_ALERTING("analytics.alerting"),
        ANALYTICS("analytics"),
        ANALYTICS_REALTIME("analytics.realtime"),
        ANALYTICS_REPORTING_SETTINGS("analytics.reporting.settings"),
        ARCHITECT("architect"),
        AUDIOHOOK("audiohook"),
        AUDIT("audit"),
        AUTH_API("auth.api"),
        AUTHORIZATION("authorization"),
        AUTOMATION_TESTING("automation.testing"),
        BOTS("bots"),
        BOTS_VOICE("bots.voice"),
        CALLBACK("callback"),
        COBROWSE("cobrowse"),
        CONTENT_MANAGEMENT("content.management"),
        CONVERSATION("conversation"),
        DATAACTIONS("dataactions"),
        DATATABLES("datatables"),
        DIRECTORY("directory"),
        EMAIL("email"),
        EVENT_ORCHESTRATION("event.orchestration"),
        EXTERNAL_CONTACTS("external.contacts"),
        GCV("gcv"),
        GDPR("gdpr"),
        GROUPS("groups"),
        HISTORICAL_ADHERENCE("historical.adherence"),
        INFRASTRUCTUREASCODE("infrastructureascode"),
        INTEGRATIONS("integrations"),
        INTENT_MINER("intent.miner"),
        JOURNEY("journey"),
        KNOWLEDGE("knowledge"),
        LANGUAGE_UNDERSTANDING("language.understanding"),
        LIMIT_REGISTRY("limit.registry"),
        MARKETPLACE("marketplace"),
        MESSAGING("messaging"),
        NOTIFICATIONS("notifications"),
        ONBOARDING("onboarding"),
        OUTBOUND("outbound"),
        PLATFORM_API("platform.api"),
        PREDICTIVE_ROUTING("predictive.routing"),
        PRESENCE("presence"),
        QUALITY("quality"),
        RECORDING("recording"),
        RESPONSE_MANAGEMENT("response.management"),
        ROUTING("routing"),
        SCIM("scim"),
        SEARCH("search"),
        SECONDARY_AUTOMATION_TESTING("secondary.automation.testing"),
        SKILLS("skills"),
        SPEECH_AND_TEXT_ANALYTICS("speech.and.text.analytics"),
        SPEECH_INTEGRATION("speech.integration"),
        SUPPORTABILITY("supportability"),
        TASK_MANAGEMENT("task.management"),
        TELEPHONY_CONFIGURATION("telephony.configuration"),
        USERS("users"),
        WEB_DEPLOYMENTS("web.deployments"),
        WEB_MESSAGING("web.messaging"),
        WEBCHAT("webchat"),
        WEBHOOKS("webhooks"),
        WORKFORCE_MANAGEMENT("workforce.management");

        private String value;

        private NamespaceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NamespaceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NamespaceEnum value : NamespaceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NamespaceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RejectReasonEnumDeserializer.class)
    public static enum RejectReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALTERNATIVEEXISTS("AlternativeExists"),
        INCREASENOTREQUIRED("IncreaseNotRequired"),
        PLATFORMMISUSE("PlatformMisuse"),
        PLATFORMSTABILITY("PlatformStability"),
        OTHERREASON("OtherReason");

        private String value;

        private RejectReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RejectReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RejectReasonEnum value : RejectReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RejectReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RejectReasonEnumDeserializer
    extends StdDeserializer<RejectReasonEnum> {
        public RejectReasonEnumDeserializer() {
            super(RejectReasonEnumDeserializer.class);
        }

        public RejectReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RejectReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class NamespaceEnumDeserializer
    extends StdDeserializer<NamespaceEnum> {
        public NamespaceEnumDeserializer() {
            super(NamespaceEnumDeserializer.class);
        }

        public NamespaceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NamespaceEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class PreviousStatusEnumDeserializer
    extends StdDeserializer<PreviousStatusEnum> {
        public PreviousStatusEnumDeserializer() {
            super(PreviousStatusEnumDeserializer.class);
        }

        public PreviousStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PreviousStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

