/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Organization
implements Serializable {
    private String id = null;
    private String name = null;
    private String defaultLanguage = null;
    private String defaultCountryCode = null;
    private String thirdPartyOrgName = null;
    private String thirdPartyURI = null;
    private String domain = null;
    private Integer version = null;
    private StateEnum state = null;
    private String defaultSiteId = null;
    private String supportURI = null;
    private Boolean voicemailEnabled = null;
    private ProductPlatformEnum productPlatform = null;
    private String selfUri = null;
    private Map<String, Boolean> features = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Organization name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Organization defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="The default language for this organization. Example: 'en'")
    @JsonProperty(value="defaultLanguage")
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public Organization defaultCountryCode(String defaultCountryCode) {
        this.defaultCountryCode = defaultCountryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The default country code for this organization. Example: 'US'")
    @JsonProperty(value="defaultCountryCode")
    public String getDefaultCountryCode() {
        return this.defaultCountryCode;
    }

    public void setDefaultCountryCode(String defaultCountryCode) {
        this.defaultCountryCode = defaultCountryCode;
    }

    @ApiModelProperty(example="null", value="The short name for the organization. This field is globally unique and cannot be changed.")
    @JsonProperty(value="thirdPartyOrgName")
    public String getThirdPartyOrgName() {
        return this.thirdPartyOrgName;
    }

    public Organization thirdPartyURI(String thirdPartyURI) {
        this.thirdPartyURI = thirdPartyURI;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="thirdPartyURI")
    public String getThirdPartyURI() {
        return this.thirdPartyURI;
    }

    public void setThirdPartyURI(String thirdPartyURI) {
        this.thirdPartyURI = thirdPartyURI;
    }

    public Organization domain(String domain) {
        this.domain = domain;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Organization version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current version of the organization.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Organization state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The current state. Examples are active, inactive, deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Organization defaultSiteId(String defaultSiteId) {
        this.defaultSiteId = defaultSiteId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="defaultSiteId")
    public String getDefaultSiteId() {
        return this.defaultSiteId;
    }

    public void setDefaultSiteId(String defaultSiteId) {
        this.defaultSiteId = defaultSiteId;
    }

    public Organization supportURI(String supportURI) {
        this.supportURI = supportURI;
        return this;
    }

    @ApiModelProperty(example="null", value="Email address where support tickets are sent to.")
    @JsonProperty(value="supportURI")
    public String getSupportURI() {
        return this.supportURI;
    }

    public void setSupportURI(String supportURI) {
        this.supportURI = supportURI;
    }

    public Organization voicemailEnabled(Boolean voicemailEnabled) {
        this.voicemailEnabled = voicemailEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="voicemailEnabled")
    public Boolean getVoicemailEnabled() {
        return this.voicemailEnabled;
    }

    public void setVoicemailEnabled(Boolean voicemailEnabled) {
        this.voicemailEnabled = voicemailEnabled;
    }

    @ApiModelProperty(example="null", value="Organizations Originating Platform.")
    @JsonProperty(value="productPlatform")
    public ProductPlatformEnum getProductPlatform() {
        return this.productPlatform;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="The state of features available for the organization.")
    @JsonProperty(value="features")
    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.id, organization.id) && Objects.equals(this.name, organization.name) && Objects.equals(this.defaultLanguage, organization.defaultLanguage) && Objects.equals(this.defaultCountryCode, organization.defaultCountryCode) && Objects.equals(this.thirdPartyOrgName, organization.thirdPartyOrgName) && Objects.equals(this.thirdPartyURI, organization.thirdPartyURI) && Objects.equals(this.domain, organization.domain) && Objects.equals(this.version, organization.version) && Objects.equals((Object)this.state, (Object)organization.state) && Objects.equals(this.defaultSiteId, organization.defaultSiteId) && Objects.equals(this.supportURI, organization.supportURI) && Objects.equals(this.voicemailEnabled, organization.voicemailEnabled) && Objects.equals((Object)this.productPlatform, (Object)organization.productPlatform) && Objects.equals(this.selfUri, organization.selfUri) && Objects.equals(this.features, organization.features);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.defaultLanguage, this.defaultCountryCode, this.thirdPartyOrgName, this.thirdPartyURI, this.domain, this.version, this.state, this.defaultSiteId, this.supportURI, this.voicemailEnabled, this.productPlatform, this.selfUri, this.features});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    defaultCountryCode: ").append(this.toIndentedString(this.defaultCountryCode)).append("\n");
        sb.append("    thirdPartyOrgName: ").append(this.toIndentedString(this.thirdPartyOrgName)).append("\n");
        sb.append("    thirdPartyURI: ").append(this.toIndentedString(this.thirdPartyURI)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    defaultSiteId: ").append(this.toIndentedString(this.defaultSiteId)).append("\n");
        sb.append("    supportURI: ").append(this.toIndentedString(this.supportURI)).append("\n");
        sb.append("    voicemailEnabled: ").append(this.toIndentedString(this.voicemailEnabled)).append("\n");
        sb.append("    productPlatform: ").append(this.toIndentedString((Object)this.productPlatform)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ProductPlatformEnumDeserializer.class)
    public static enum ProductPlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENESYSCLOUD("GenesysCloud"),
        PURECLOUD("PureCloud"),
        PUREENGAGE("PureEngage"),
        PUREENGAGECLOUD("PureEngageCloud"),
        PURECONNECT("PureConnect"),
        PURECONNECTCLOUD("PureConnectCloud"),
        UNKNOWN("Unknown");

        private String value;

        private ProductPlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProductPlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ProductPlatformEnum value : ProductPlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ProductPlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ProductPlatformEnumDeserializer
    extends StdDeserializer<ProductPlatformEnum> {
        public ProductPlatformEnumDeserializer() {
            super(ProductPlatformEnumDeserializer.class);
        }

        public ProductPlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ProductPlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

