/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class MessageEvaluation
implements Serializable {
    private String contactColumn = null;
    private String contactAddress = null;
    private MessageTypeEnum messageType = null;
    private String wrapupCodeId = null;
    private Date timestamp = null;

    public MessageEvaluation contactColumn(String contactColumn) {
        this.contactColumn = contactColumn;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the contact column that was wrapped up")
    @JsonProperty(value="contactColumn")
    public String getContactColumn() {
        return this.contactColumn;
    }

    public void setContactColumn(String contactColumn) {
        this.contactColumn = contactColumn;
    }

    public MessageEvaluation contactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The address (phone or email) that was wrapped up")
    @JsonProperty(value="contactAddress")
    public String getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public MessageEvaluation messageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of message sent")
    @JsonProperty(value="messageType")
    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
    }

    public MessageEvaluation wrapupCodeId(String wrapupCodeId) {
        this.wrapupCodeId = wrapupCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the wrap-up code")
    @JsonProperty(value="wrapupCodeId")
    public String getWrapupCodeId() {
        return this.wrapupCodeId;
    }

    public void setWrapupCodeId(String wrapupCodeId) {
        this.wrapupCodeId = wrapupCodeId;
    }

    public MessageEvaluation timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", value="The time that the wrap-up was applied. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEvaluation messageEvaluation = (MessageEvaluation)o;
        return Objects.equals(this.contactColumn, messageEvaluation.contactColumn) && Objects.equals(this.contactAddress, messageEvaluation.contactAddress) && Objects.equals((Object)this.messageType, (Object)messageEvaluation.messageType) && Objects.equals(this.wrapupCodeId, messageEvaluation.wrapupCodeId) && Objects.equals(this.timestamp, messageEvaluation.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contactColumn, this.contactAddress, this.messageType, this.wrapupCodeId, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageEvaluation {\n");
        sb.append("    contactColumn: ").append(this.toIndentedString(this.contactColumn)).append("\n");
        sb.append("    contactAddress: ").append(this.toIndentedString(this.contactAddress)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString((Object)this.messageType)).append("\n");
        sb.append("    wrapupCodeId: ").append(this.toIndentedString(this.wrapupCodeId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MessageTypeEnumDeserializer.class)
    public static enum MessageTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("Sms"),
        EMAIL("Email");

        private String value;

        private MessageTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessageTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessageTypeEnum value : MessageTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessageTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessageTypeEnumDeserializer
    extends StdDeserializer<MessageTypeEnum> {
        public MessageTypeEnumDeserializer() {
            super(MessageTypeEnumDeserializer.class);
        }

        public MessageTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessageTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

