/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class LearningSlot
implements Serializable {
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private Double staffingDifference = null;
    private DifferenceRatingEnum differenceRating = null;

    public LearningSlot dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date and time of scheduled Learning activity slot. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public LearningSlot lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Length of Learning activity slot in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public LearningSlot staffingDifference(Double staffingDifference) {
        this.staffingDifference = staffingDifference;
        return this;
    }

    @ApiModelProperty(example="null", value="Difference between scheduled and forecast headcount for this slot after scheduling the Learning activity")
    @JsonProperty(value="staffingDifference")
    public Double getStaffingDifference() {
        return this.staffingDifference;
    }

    public void setStaffingDifference(Double staffingDifference) {
        this.staffingDifference = staffingDifference;
    }

    public LearningSlot differenceRating(DifferenceRatingEnum differenceRating) {
        this.differenceRating = differenceRating;
        return this;
    }

    @ApiModelProperty(example="null", value="Rating based on the staffing difference for scheduled slot")
    @JsonProperty(value="differenceRating")
    public DifferenceRatingEnum getDifferenceRating() {
        return this.differenceRating;
    }

    public void setDifferenceRating(DifferenceRatingEnum differenceRating) {
        this.differenceRating = differenceRating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningSlot learningSlot = (LearningSlot)o;
        return Objects.equals(this.dateStart, learningSlot.dateStart) && Objects.equals(this.lengthInMinutes, learningSlot.lengthInMinutes) && Objects.equals(this.staffingDifference, learningSlot.staffingDifference) && Objects.equals((Object)this.differenceRating, (Object)learningSlot.differenceRating);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateStart, this.lengthInMinutes, this.staffingDifference, this.differenceRating});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningSlot {\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    staffingDifference: ").append(this.toIndentedString(this.staffingDifference)).append("\n");
        sb.append("    differenceRating: ").append(this.toIndentedString((Object)this.differenceRating)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DifferenceRatingEnumDeserializer.class)
    public static enum DifferenceRatingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        POOR("Poor"),
        NEUTRAL("Neutral"),
        GOOD("Good");

        private String value;

        private DifferenceRatingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DifferenceRatingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DifferenceRatingEnum value : DifferenceRatingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DifferenceRatingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DifferenceRatingEnumDeserializer
    extends StdDeserializer<DifferenceRatingEnum> {
        public DifferenceRatingEnumDeserializer() {
            super(DifferenceRatingEnumDeserializer.class);
        }

        public DifferenceRatingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DifferenceRatingEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

