/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.LeaderboardItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Leaderboard
implements Serializable {
    private Division division = null;
    private AddressableEntityRef metric = null;
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;
    private List<LeaderboardItem> leaders = new ArrayList<LeaderboardItem>();
    private LeaderboardItem userRank = null;
    private AddressableEntityRef performanceProfile = null;

    @ApiModelProperty(example="null", value="The targeted division for this leaderboard")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    @ApiModelProperty(example="null", value="The metric id if the leaderboard is about a specific metric")
    @JsonProperty(value="metric")
    public AddressableEntityRef getMetric() {
        return this.metric;
    }

    @ApiModelProperty(example="null", value="Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    @ApiModelProperty(example="null", value="End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    @ApiModelProperty(example="null", value="The list of leaders generated.")
    @JsonProperty(value="leaders")
    public List<LeaderboardItem> getLeaders() {
        return this.leaders;
    }

    @ApiModelProperty(example="null", value="The requesting user's rank")
    @JsonProperty(value="userRank")
    public LeaderboardItem getUserRank() {
        return this.userRank;
    }

    @ApiModelProperty(example="null", value="The targeted performance profile for the average points")
    @JsonProperty(value="performanceProfile")
    public AddressableEntityRef getPerformanceProfile() {
        return this.performanceProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Leaderboard leaderboard = (Leaderboard)o;
        return Objects.equals(this.division, leaderboard.division) && Objects.equals(this.metric, leaderboard.metric) && Objects.equals(this.dateStartWorkday, leaderboard.dateStartWorkday) && Objects.equals(this.dateEndWorkday, leaderboard.dateEndWorkday) && Objects.equals(this.leaders, leaderboard.leaders) && Objects.equals(this.userRank, leaderboard.userRank) && Objects.equals(this.performanceProfile, leaderboard.performanceProfile);
    }

    public int hashCode() {
        return Objects.hash(this.division, this.metric, this.dateStartWorkday, this.dateEndWorkday, this.leaders, this.userRank, this.performanceProfile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Leaderboard {\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("    leaders: ").append(this.toIndentedString(this.leaders)).append("\n");
        sb.append("    userRank: ").append(this.toIndentedString(this.userRank)).append("\n");
        sb.append("    performanceProfile: ").append(this.toIndentedString(this.performanceProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

