/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class GoogleDialogflowCustomSettings
implements Serializable {
    private String environment = null;
    private String eventName = null;
    private Map<String, String> webhookQueryParameters = null;
    private Map<String, String> eventInputParameters = null;

    public GoogleDialogflowCustomSettings environment(String environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(example="null", value="If set this environment will be used to initiate the dialogflow bot, otherwise the default configuration will be used.  See https://cloud.google.com/dialogflow/docs/agents-versions")
    @JsonProperty(value="environment")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public GoogleDialogflowCustomSettings eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", value="If set this eventName will be used to initiate the dialogflow bot rather than language processing on the input text.  See https://cloud.google.com/dialogflow/es/docs/events-overview")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public GoogleDialogflowCustomSettings webhookQueryParameters(Map<String, String> webhookQueryParameters) {
        this.webhookQueryParameters = webhookQueryParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Parameters passed to the fulfillment webhook of the bot (if any).")
    @JsonProperty(value="webhookQueryParameters")
    public Map<String, String> getWebhookQueryParameters() {
        return this.webhookQueryParameters;
    }

    public void setWebhookQueryParameters(Map<String, String> webhookQueryParameters) {
        this.webhookQueryParameters = webhookQueryParameters;
    }

    public GoogleDialogflowCustomSettings eventInputParameters(Map<String, String> eventInputParameters) {
        this.eventInputParameters = eventInputParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Parameters passed to the event input of the bot.")
    @JsonProperty(value="eventInputParameters")
    public Map<String, String> getEventInputParameters() {
        return this.eventInputParameters;
    }

    public void setEventInputParameters(Map<String, String> eventInputParameters) {
        this.eventInputParameters = eventInputParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleDialogflowCustomSettings googleDialogflowCustomSettings = (GoogleDialogflowCustomSettings)o;
        return Objects.equals(this.environment, googleDialogflowCustomSettings.environment) && Objects.equals(this.eventName, googleDialogflowCustomSettings.eventName) && Objects.equals(this.webhookQueryParameters, googleDialogflowCustomSettings.webhookQueryParameters) && Objects.equals(this.eventInputParameters, googleDialogflowCustomSettings.eventInputParameters);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.eventName, this.webhookQueryParameters, this.eventInputParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GoogleDialogflowCustomSettings {\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    webhookQueryParameters: ").append(this.toIndentedString(this.webhookQueryParameters)).append("\n");
        sb.append("    eventInputParameters: ").append(this.toIndentedString(this.eventInputParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

