/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Check
implements Serializable {
    private ResultEnum result = null;
    private TypeEnum type = null;

    @ApiModelProperty(example="null", value="The result of a check executed. This indicates if the check was successful or not.")
    @JsonProperty(value="result")
    public ResultEnum getResult() {
        return this.result;
    }

    @ApiModelProperty(example="null", value="The type of check executed.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Check check = (Check)o;
        return Objects.equals((Object)this.result, (Object)check.result) && Objects.equals((Object)this.type, (Object)check.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.result, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Check {\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HANDLETIMEVALUE("HandleTimeValue"),
        TRANSFERRATEVALUE("TransferRateValue"),
        SALESCONVERSIONRATEVALUE("SalesConversionRateValue"),
        SALESAMOUNTVALUE("SalesAmountValue"),
        RETENTIONRATEVALUE("RetentionRateValue"),
        CHURNRATEVALUE("ChurnRateValue"),
        INTERACTIONVOLUME("InteractionVolume"),
        USERVARIANCE("UserVariance"),
        DATACOVERAGE("DataCoverage"),
        MODELQUALITY("ModelQuality");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ResultEnumDeserializer.class)
    public static enum ResultEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PASSED("Passed"),
        FAILED("Failed"),
        UNKNOWN("Unknown"),
        SKIPPED("Skipped"),
        ERROR("Error");

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ResultEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ResultEnum value : ResultEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ResultEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ResultEnumDeserializer
    extends StdDeserializer<ResultEnum> {
        public ResultEnumDeserializer() {
            super(ResultEnumDeserializer.class);
        }

        public ResultEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ResultEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

