/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UpdateCoachingAppointmentRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchCoachingAppointmentRequest {
    private String appointmentId;
    private UpdateCoachingAppointmentRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public PatchCoachingAppointmentRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public UpdateCoachingAppointmentRequest getBody() {
        return this.body;
    }

    public void setBody(UpdateCoachingAppointmentRequest body) {
        this.body = body;
    }

    public PatchCoachingAppointmentRequest withBody(UpdateCoachingAppointmentRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchCoachingAppointmentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UpdateCoachingAppointmentRequest> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/coaching/appointments/{appointmentId}").withPathParameter("appointmentId", this.appointmentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, UpdateCoachingAppointmentRequest body) {
        return new Builder().withRequiredParams(appointmentId, body);
    }

    public static class Builder {
        private final PatchCoachingAppointmentRequest request = new PatchCoachingAppointmentRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withBody(UpdateCoachingAppointmentRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, UpdateCoachingAppointmentRequest body) {
            this.request.setAppointmentId(appointmentId);
            this.request.setBody(body);
            return this;
        }

        public PatchCoachingAppointmentRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentRequest.");
            }
            return this.request;
        }
    }
}

