/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecordingUploadReportRequest
implements Serializable {
    private Date dateSince = null;
    private UploadStatusEnum uploadStatus = null;

    public RecordingUploadReportRequest dateSince(Date dateSince) {
        this.dateSince = dateSince;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Report will include uploads since this date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateSince")
    public Date getDateSince() {
        return this.dateSince;
    }

    public void setDateSince(Date dateSince) {
        this.dateSince = dateSince;
    }

    public RecordingUploadReportRequest uploadStatus(UploadStatusEnum uploadStatus) {
        this.uploadStatus = uploadStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Report will include uploads with this status")
    @JsonProperty(value="uploadStatus")
    public UploadStatusEnum getUploadStatus() {
        return this.uploadStatus;
    }

    public void setUploadStatus(UploadStatusEnum uploadStatus) {
        this.uploadStatus = uploadStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingUploadReportRequest recordingUploadReportRequest = (RecordingUploadReportRequest)o;
        return Objects.equals(this.dateSince, recordingUploadReportRequest.dateSince) && Objects.equals((Object)this.uploadStatus, (Object)recordingUploadReportRequest.uploadStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateSince, this.uploadStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingUploadReportRequest {\n");
        sb.append("    dateSince: ").append(this.toIndentedString(this.dateSince)).append("\n");
        sb.append("    uploadStatus: ").append(this.toIndentedString((Object)this.uploadStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UploadStatusEnumDeserializer.class)
    public static enum UploadStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        SUCCESS("Success"),
        FAILURE("Failure");

        private String value;

        private UploadStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UploadStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UploadStatusEnum value : UploadStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UploadStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UploadStatusEnumDeserializer
    extends StdDeserializer<UploadStatusEnum> {
        public UploadStatusEnumDeserializer() {
            super(UploadStatusEnumDeserializer.class);
        }

        public UploadStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UploadStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

