/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetOauthScopeRequest {
    private String scopeId;
    private String acceptLanguage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public GetOauthScopeRequest withScopeId(String scopeId) {
        this.setScopeId(scopeId);
        return this;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public GetOauthScopeRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOauthScopeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.scopeId == null) {
            throw new IllegalStateException("Missing the required parameter 'scopeId' when building request for GetOauthScopeRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/oauth/scopes/{scopeId}").withPathParameter("scopeId", this.scopeId).withHeaderParameter("Accept-Language", this.acceptLanguage).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scopeId) {
        return new Builder().withRequiredParams(scopeId);
    }

    public static class Builder {
        private final GetOauthScopeRequest request = new GetOauthScopeRequest();

        private Builder() {
        }

        public Builder withScopeId(String scopeId) {
            this.request.setScopeId(scopeId);
            return this;
        }

        public Builder withAcceptLanguage(String acceptLanguage) {
            this.request.setAcceptLanguage(acceptLanguage);
            return this;
        }

        public Builder withRequiredParams(String scopeId) {
            this.request.setScopeId(scopeId);
            return this;
        }

        public GetOauthScopeRequest build() {
            if (this.request.scopeId == null) {
                throw new IllegalStateException("Missing the required parameter 'scopeId' when building request for GetOauthScopeRequest.");
            }
            return this.request;
        }
    }
}

