/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class FreeSeatingConfiguration
implements Serializable {
    private FreeSeatingStateEnum freeSeatingState = null;
    private Integer ttlMinutes = null;

    public FreeSeatingConfiguration freeSeatingState(FreeSeatingStateEnum freeSeatingState) {
        this.freeSeatingState = freeSeatingState;
        return this;
    }

    @ApiModelProperty(example="null", value="The FreeSeatingState for FreeSeatingConfiguration. Can be ON, OFF, or PARTIAL. ON meaning disassociate the user after the ttl expires, OFF meaning never disassociate the user, and PARTIAL meaning only disassociate when a user explicitly clicks log out.")
    @JsonProperty(value="freeSeatingState")
    public FreeSeatingStateEnum getFreeSeatingState() {
        return this.freeSeatingState;
    }

    public void setFreeSeatingState(FreeSeatingStateEnum freeSeatingState) {
        this.freeSeatingState = freeSeatingState;
    }

    public FreeSeatingConfiguration ttlMinutes(Integer ttlMinutes) {
        this.ttlMinutes = ttlMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time in minutes until an offline user is disassociated from their station")
    @JsonProperty(value="ttlMinutes")
    public Integer getTtlMinutes() {
        return this.ttlMinutes;
    }

    public void setTtlMinutes(Integer ttlMinutes) {
        this.ttlMinutes = ttlMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeSeatingConfiguration freeSeatingConfiguration = (FreeSeatingConfiguration)o;
        return Objects.equals((Object)this.freeSeatingState, (Object)freeSeatingConfiguration.freeSeatingState) && Objects.equals(this.ttlMinutes, freeSeatingConfiguration.ttlMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.freeSeatingState, this.ttlMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FreeSeatingConfiguration {\n");
        sb.append("    freeSeatingState: ").append(this.toIndentedString((Object)this.freeSeatingState)).append("\n");
        sb.append("    ttlMinutes: ").append(this.toIndentedString(this.ttlMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FreeSeatingStateEnumDeserializer.class)
    public static enum FreeSeatingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ON("ON"),
        OFF("OFF"),
        PARTIAL("PARTIAL");

        private String value;

        private FreeSeatingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FreeSeatingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FreeSeatingStateEnum value : FreeSeatingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FreeSeatingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FreeSeatingStateEnumDeserializer
    extends StdDeserializer<FreeSeatingStateEnum> {
        public FreeSeatingStateEnumDeserializer() {
            super(FreeSeatingStateEnumDeserializer.class);
        }

        public FreeSeatingStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FreeSeatingStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

