/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.TeamMembers;
import java.util.HashMap;
import java.util.Map;

public class PostTeamMembersRequest {
    private String teamId;
    private TeamMembers body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public PostTeamMembersRequest withTeamId(String teamId) {
        this.setTeamId(teamId);
        return this;
    }

    public TeamMembers getBody() {
        return this.body;
    }

    public void setBody(TeamMembers body) {
        this.body = body;
    }

    public PostTeamMembersRequest withBody(TeamMembers body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostTeamMembersRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<TeamMembers> withHttpInfo() {
        if (this.teamId == null) {
            throw new IllegalStateException("Missing the required parameter 'teamId' when building request for PostTeamMembersRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostTeamMembersRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/teams/{teamId}/members").withPathParameter("teamId", this.teamId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String teamId, TeamMembers body) {
        return new Builder().withRequiredParams(teamId, body);
    }

    public static class Builder {
        private final PostTeamMembersRequest request = new PostTeamMembersRequest();

        private Builder() {
        }

        public Builder withTeamId(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public Builder withBody(TeamMembers body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String teamId, TeamMembers body) {
            this.request.setTeamId(teamId);
            this.request.setBody(body);
            return this;
        }

        public PostTeamMembersRequest build() {
            if (this.request.teamId == null) {
                throw new IllegalStateException("Missing the required parameter 'teamId' when building request for PostTeamMembersRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostTeamMembersRequest.");
            }
            return this.request;
        }
    }
}

