/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWidgetsDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PostWidgetsDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PutWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.model.WidgetDeployment;
import com.mypurecloud.sdk.v2.model.WidgetDeploymentEntityListing;
import java.util.concurrent.Future;

public class WidgetsApiAsync {
    private final ApiClient pcapiClient;

    public WidgetsApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public WidgetsApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<Void> deleteWidgetsDeploymentAsync(DeleteWidgetsDeploymentRequest request, final AsyncApiCallback<Void> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        WidgetsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Void>> deleteWidgetsDeploymentAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Void>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, null, new AsyncApiCallback<ApiResponse<Void>>(){

                @Override
                public void onCompleted(ApiResponse<Void> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<WidgetDeployment> getWidgetsDeploymentAsync(GetWidgetsDeploymentRequest request, final AsyncApiCallback<WidgetDeployment> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        WidgetsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<WidgetDeployment>> getWidgetsDeploymentAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<WidgetDeployment>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<WidgetDeploymentEntityListing> getWidgetsDeploymentsAsync(GetWidgetsDeploymentsRequest request, final AsyncApiCallback<WidgetDeploymentEntityListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<WidgetDeploymentEntityListing>(){}, new AsyncApiCallback<ApiResponse<WidgetDeploymentEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeploymentEntityListing> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        WidgetsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<WidgetDeploymentEntityListing>> getWidgetsDeploymentsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<WidgetDeploymentEntityListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<WidgetDeploymentEntityListing>(){}, new AsyncApiCallback<ApiResponse<WidgetDeploymentEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeploymentEntityListing> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<WidgetDeployment> postWidgetsDeploymentsAsync(PostWidgetsDeploymentsRequest request, final AsyncApiCallback<WidgetDeployment> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        WidgetsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<WidgetDeployment>> postWidgetsDeploymentsAsync(ApiRequest<WidgetDeployment> request, final AsyncApiCallback<ApiResponse<WidgetDeployment>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<WidgetDeployment> putWidgetsDeploymentAsync(PutWidgetsDeploymentRequest request, final AsyncApiCallback<WidgetDeployment> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        WidgetsApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<WidgetDeployment>> putWidgetsDeploymentAsync(ApiRequest<WidgetDeployment> request, final AsyncApiCallback<ApiResponse<WidgetDeployment>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<WidgetDeployment>(){}, new AsyncApiCallback<ApiResponse<WidgetDeployment>>(){

                @Override
                public void onCompleted(ApiResponse<WidgetDeployment> response) {
                    WidgetsApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        WidgetsApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        WidgetsApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

