/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Used to filter response queries")
public class ResponseFilter
implements Serializable {
    private String name = null;
    private OperatorEnum operator = null;
    private List<String> values = new ArrayList<String>();

    public ResponseFilter name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Field to filter on. Allowed values are 'name' and 'libraryId.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResponseFilter operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filter operation: IN, EQUALS, NOTEQUALS.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ResponseFilter values(List<String> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Values to filter on.")
    @JsonProperty(value="values")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseFilter responseFilter = (ResponseFilter)o;
        return Objects.equals(this.name, responseFilter.name) && Objects.equals((Object)this.operator, (Object)responseFilter.operator) && Objects.equals(this.values, responseFilter.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.operator, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseFilter {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IN("IN"),
        EQUALS("EQUALS"),
        NOTEQUALS("NOTEQUALS");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

