/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RecordingEncryptionConfiguration;
import java.util.HashMap;
import java.util.Map;

public class PutRecordingKeyconfigurationRequest {
    private String keyConfigurationId;
    private RecordingEncryptionConfiguration body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKeyConfigurationId() {
        return this.keyConfigurationId;
    }

    public void setKeyConfigurationId(String keyConfigurationId) {
        this.keyConfigurationId = keyConfigurationId;
    }

    public PutRecordingKeyconfigurationRequest withKeyConfigurationId(String keyConfigurationId) {
        this.setKeyConfigurationId(keyConfigurationId);
        return this;
    }

    public RecordingEncryptionConfiguration getBody() {
        return this.body;
    }

    public void setBody(RecordingEncryptionConfiguration body) {
        this.body = body;
    }

    public PutRecordingKeyconfigurationRequest withBody(RecordingEncryptionConfiguration body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRecordingKeyconfigurationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RecordingEncryptionConfiguration> withHttpInfo() {
        if (this.keyConfigurationId == null) {
            throw new IllegalStateException("Missing the required parameter 'keyConfigurationId' when building request for PutRecordingKeyconfigurationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRecordingKeyconfigurationRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/recording/keyconfigurations/{keyConfigurationId}").withPathParameter("keyConfigurationId", this.keyConfigurationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String keyConfigurationId, RecordingEncryptionConfiguration body) {
        return new Builder().withRequiredParams(keyConfigurationId, body);
    }

    public static class Builder {
        private final PutRecordingKeyconfigurationRequest request = new PutRecordingKeyconfigurationRequest();

        private Builder() {
        }

        public Builder withKeyConfigurationId(String keyConfigurationId) {
            this.request.setKeyConfigurationId(keyConfigurationId);
            return this;
        }

        public Builder withBody(RecordingEncryptionConfiguration body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String keyConfigurationId, RecordingEncryptionConfiguration body) {
            this.request.setKeyConfigurationId(keyConfigurationId);
            this.request.setBody(body);
            return this;
        }

        public PutRecordingKeyconfigurationRequest build() {
            if (this.request.keyConfigurationId == null) {
                throw new IllegalStateException("Missing the required parameter 'keyConfigurationId' when building request for PutRecordingKeyconfigurationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRecordingKeyconfigurationRequest.");
            }
            return this.request;
        }
    }
}

