/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetChatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchChatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PutChatSettingsRequest;
import com.mypurecloud.sdk.v2.model.ChatSettings;
import java.io.IOException;

public class ChatApi {
    private final ApiClient pcapiClient;

    public ChatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChatApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public ChatSettings getChatSettings() throws IOException, ApiException {
        return this.getChatSettings(this.createGetChatSettingsRequest());
    }

    public ApiResponse<ChatSettings> getChatSettingsWithHttpInfo() throws IOException {
        return this.getChatSettings(this.createGetChatSettingsRequest().withHttpInfo());
    }

    private GetChatSettingsRequest createGetChatSettingsRequest() {
        return GetChatSettingsRequest.builder().build();
    }

    public ChatSettings getChatSettings(GetChatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> getChatSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSettings patchChatSettings(ChatSettings body) throws IOException, ApiException {
        return this.patchChatSettings(this.createPatchChatSettingsRequest(body));
    }

    public ApiResponse<ChatSettings> patchChatSettingsWithHttpInfo(ChatSettings body) throws IOException {
        return this.patchChatSettings(this.createPatchChatSettingsRequest(body).withHttpInfo());
    }

    private PatchChatSettingsRequest createPatchChatSettingsRequest(ChatSettings body) {
        return PatchChatSettingsRequest.builder().withBody(body).build();
    }

    public ChatSettings patchChatSettings(PatchChatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> patchChatSettings(ApiRequest<ChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSettings putChatSettings(ChatSettings body) throws IOException, ApiException {
        return this.putChatSettings(this.createPutChatSettingsRequest(body));
    }

    public ApiResponse<ChatSettings> putChatSettingsWithHttpInfo(ChatSettings body) throws IOException {
        return this.putChatSettings(this.createPutChatSettingsRequest(body).withHttpInfo());
    }

    private PutChatSettingsRequest createPutChatSettingsRequest(ChatSettings body) {
        return PutChatSettingsRequest.builder().withBody(body).build();
    }

    public ChatSettings putChatSettings(PutChatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> putChatSettings(ApiRequest<ChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

