/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LanguageReference;
import com.mypurecloud.sdk.v2.model.QueueReference;
import com.mypurecloud.sdk.v2.model.RoutingSkillReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import com.mypurecloud.sdk.v2.model.WorkPlanReference;
import com.mypurecloud.sdk.v2.model.WorkPlanRotationReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WfmAgent
implements Serializable {
    private String id = null;
    private UserReference user = null;
    private WorkPlanReference workPlan = null;
    private WorkPlanRotationReference workPlanRotation = null;
    private Boolean acceptDirectShiftTrades = null;
    private List<QueueReference> queues = new ArrayList<QueueReference>();
    private List<LanguageReference> languages = new ArrayList<LanguageReference>();
    private List<RoutingSkillReference> skills = new ArrayList<RoutingSkillReference>();
    private Boolean schedulable = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WfmAgent user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user associated with this data")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public WfmAgent workPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="The work plan associated with this agent, if applicable")
    @JsonProperty(value="workPlan")
    public WorkPlanReference getWorkPlan() {
        return this.workPlan;
    }

    public void setWorkPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
    }

    public WfmAgent workPlanRotation(WorkPlanRotationReference workPlanRotation) {
        this.workPlanRotation = workPlanRotation;
        return this;
    }

    @ApiModelProperty(example="null", value="The work plan rotation associated with this agent, if applicable")
    @JsonProperty(value="workPlanRotation")
    public WorkPlanRotationReference getWorkPlanRotation() {
        return this.workPlanRotation;
    }

    public void setWorkPlanRotation(WorkPlanRotationReference workPlanRotation) {
        this.workPlanRotation = workPlanRotation;
    }

    public WfmAgent acceptDirectShiftTrades(Boolean acceptDirectShiftTrades) {
        this.acceptDirectShiftTrades = acceptDirectShiftTrades;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the agent accepts direct shift trade requests")
    @JsonProperty(value="acceptDirectShiftTrades")
    public Boolean getAcceptDirectShiftTrades() {
        return this.acceptDirectShiftTrades;
    }

    public void setAcceptDirectShiftTrades(Boolean acceptDirectShiftTrades) {
        this.acceptDirectShiftTrades = acceptDirectShiftTrades;
    }

    public WfmAgent queues(List<QueueReference> queues) {
        this.queues = queues;
        return this;
    }

    @ApiModelProperty(example="null", value="List of queues to which this agent is capable of handling")
    @JsonProperty(value="queues")
    public List<QueueReference> getQueues() {
        return this.queues;
    }

    public void setQueues(List<QueueReference> queues) {
        this.queues = queues;
    }

    public WfmAgent languages(List<LanguageReference> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of languages this agent is capable of handling")
    @JsonProperty(value="languages")
    public List<LanguageReference> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<LanguageReference> languages) {
        this.languages = languages;
    }

    public WfmAgent skills(List<RoutingSkillReference> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of skills this agent is capable of handling")
    @JsonProperty(value="skills")
    public List<RoutingSkillReference> getSkills() {
        return this.skills;
    }

    public void setSkills(List<RoutingSkillReference> skills) {
        this.skills = skills;
    }

    public WfmAgent schedulable(Boolean schedulable) {
        this.schedulable = schedulable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the agent has the permission to be included in schedule generation")
    @JsonProperty(value="schedulable")
    public Boolean getSchedulable() {
        return this.schedulable;
    }

    public void setSchedulable(Boolean schedulable) {
        this.schedulable = schedulable;
    }

    public WfmAgent metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Metadata for this agent")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmAgent wfmAgent = (WfmAgent)o;
        return Objects.equals(this.id, wfmAgent.id) && Objects.equals(this.user, wfmAgent.user) && Objects.equals(this.workPlan, wfmAgent.workPlan) && Objects.equals(this.workPlanRotation, wfmAgent.workPlanRotation) && Objects.equals(this.acceptDirectShiftTrades, wfmAgent.acceptDirectShiftTrades) && Objects.equals(this.queues, wfmAgent.queues) && Objects.equals(this.languages, wfmAgent.languages) && Objects.equals(this.skills, wfmAgent.skills) && Objects.equals(this.schedulable, wfmAgent.schedulable) && Objects.equals(this.metadata, wfmAgent.metadata) && Objects.equals(this.selfUri, wfmAgent.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.user, this.workPlan, this.workPlanRotation, this.acceptDirectShiftTrades, this.queues, this.languages, this.skills, this.schedulable, this.metadata, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmAgent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    workPlan: ").append(this.toIndentedString(this.workPlan)).append("\n");
        sb.append("    workPlanRotation: ").append(this.toIndentedString(this.workPlanRotation)).append("\n");
        sb.append("    acceptDirectShiftTrades: ").append(this.toIndentedString(this.acceptDirectShiftTrades)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    schedulable: ").append(this.toIndentedString(this.schedulable)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

