/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AuditQueryFilter;
import com.mypurecloud.sdk.v2.model.AuditQuerySort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AuditQueryRequest
implements Serializable {
    private String interval = null;
    private ServiceNameEnum serviceName = null;
    private List<AuditQueryFilter> filters = new ArrayList<AuditQueryFilter>();
    private List<AuditQuerySort> sort = new ArrayList<AuditQuerySort>();

    public AuditQueryRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time range of data to query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ssZ/YYYY-MM-DDThh:mm:ssZ")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AuditQueryRequest serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the service to query audits for.")
    @JsonProperty(value="serviceName")
    public ServiceNameEnum getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public AuditQueryRequest filters(List<AuditQueryFilter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional filters for the query.")
    @JsonProperty(value="filters")
    public List<AuditQueryFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<AuditQueryFilter> filters) {
        this.filters = filters;
    }

    public AuditQueryRequest sort(List<AuditQuerySort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort parameter for the query.")
    @JsonProperty(value="sort")
    public List<AuditQuerySort> getSort() {
        return this.sort;
    }

    public void setSort(List<AuditQuerySort> sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditQueryRequest auditQueryRequest = (AuditQueryRequest)o;
        return Objects.equals(this.interval, auditQueryRequest.interval) && Objects.equals((Object)this.serviceName, (Object)auditQueryRequest.serviceName) && Objects.equals(this.filters, auditQueryRequest.filters) && Objects.equals(this.sort, auditQueryRequest.sort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.serviceName, this.filters, this.sort});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditQueryRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString((Object)this.serviceName)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ServiceNameEnumDeserializer.class)
    public static enum ServiceNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTCONFIG("AgentConfig"),
        ANALYTICSREPORTING("AnalyticsReporting"),
        ARCHITECT("Architect"),
        COACHING("Coaching"),
        CONTACTCENTER("ContactCenter"),
        CONTENTMANAGEMENT("ContentManagement"),
        DATATABLES("Datatables"),
        DIRECTORY("Directory"),
        DYNAMICSCHEMA("DynamicSchema"),
        GAMIFICATION("Gamification"),
        GROUPS("Groups"),
        INTEGRATIONS("Integrations"),
        KNOWLEDGE("Knowledge"),
        LANGUAGEUNDERSTANDING("LanguageUnderstanding"),
        LEARNING("Learning"),
        LIMITS("Limits"),
        LOGCAPTURE("LogCapture"),
        OUTBOUND("Outbound"),
        PEOPLEPERMISSIONS("PeoplePermissions"),
        EMPLOYEEPERFORMANCE("EmployeePerformance"),
        PREDICTIVEENGAGEMENT("PredictiveEngagement"),
        PRESENCE("Presence"),
        QUALITY("Quality"),
        RESPONSEMANAGEMENT("ResponseManagement"),
        ROUTING("Routing"),
        SPEECHANDTEXTANALYTICS("SpeechAndTextAnalytics"),
        TELEPHONY("Telephony"),
        TOPICSDEFINITIONS("TopicsDefinitions"),
        TRIGGERS("Triggers"),
        PROCESSAUTOMATION("ProcessAutomation"),
        VOICEMAIL("Voicemail"),
        WEBDEPLOYMENTS("WebDeployments"),
        WEBHOOKS("Webhooks"),
        WORKFORCEMANAGEMENT("WorkforceManagement"),
        MESSAGING("Messaging"),
        SUPPORTABILITY("Supportability"),
        CALLBACK("Callback"),
        WORKITEMS("Workitems"),
        SCIM("SCIM"),
        NUMBERPURCHASING("NumberPurchasing"),
        MARKETPLACE("Marketplace");

        private String value;

        private ServiceNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServiceNameEnum value : ServiceNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServiceNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ServiceNameEnumDeserializer
    extends StdDeserializer<ServiceNameEnum> {
        public ServiceNameEnumDeserializer() {
            super(ServiceNameEnumDeserializer.class);
        }

        public ServiceNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServiceNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

