/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeImportJobSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeImportJobRequest
implements Serializable {
    private String uploadKey = null;
    private FileTypeEnum fileType = null;
    private KnowledgeImportJobSettings settings = null;

    public KnowledgeImportJobRequest uploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Upload key")
    @JsonProperty(value="uploadKey")
    public String getUploadKey() {
        return this.uploadKey;
    }

    public void setUploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
    }

    public KnowledgeImportJobRequest fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="File type of the document")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public KnowledgeImportJobRequest settings(KnowledgeImportJobSettings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional optional settings")
    @JsonProperty(value="settings")
    public KnowledgeImportJobSettings getSettings() {
        return this.settings;
    }

    public void setSettings(KnowledgeImportJobSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeImportJobRequest knowledgeImportJobRequest = (KnowledgeImportJobRequest)o;
        return Objects.equals(this.uploadKey, knowledgeImportJobRequest.uploadKey) && Objects.equals((Object)this.fileType, (Object)knowledgeImportJobRequest.fileType) && Objects.equals(this.settings, knowledgeImportJobRequest.settings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uploadKey, this.fileType, this.settings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeImportJobRequest {\n");
        sb.append("    uploadKey: ").append(this.toIndentedString(this.uploadKey)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        JSON("Json"),
        CSV("Csv");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

