/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.IntegrationConfigurationCredential;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Configuration for an Integration")
public class IntegrationConfiguration
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer version = null;
    private Object properties = null;
    private Object advanced = null;
    private String notes = null;
    private Map<String, IntegrationConfigurationCredential> credentials = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public IntegrationConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the integration, used to distinguish this integration from others of the same type.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntegrationConfiguration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public IntegrationConfiguration properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Key-value configuration settings described by the schema in the propertiesSchemaUri field.")
    @JsonProperty(value="properties")
    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public IntegrationConfiguration advanced(Object advanced) {
        this.advanced = advanced;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Advanced configuration described by the schema in the advancedSchemaUri field.")
    @JsonProperty(value="advanced")
    public Object getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(Object advanced) {
        this.advanced = advanced;
    }

    public IntegrationConfiguration notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Notes about the integration.")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public IntegrationConfiguration credentials(Map<String, IntegrationConfigurationCredential> credentials) {
        this.credentials = credentials;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Credentials required by the integration. The required keys are indicated in the credentials property of the Integration Type")
    @JsonProperty(value="credentials")
    public Map<String, IntegrationConfigurationCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, IntegrationConfigurationCredential> credentials) {
        this.credentials = credentials;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationConfiguration integrationConfiguration = (IntegrationConfiguration)o;
        return Objects.equals(this.id, integrationConfiguration.id) && Objects.equals(this.name, integrationConfiguration.name) && Objects.equals(this.version, integrationConfiguration.version) && Objects.equals(this.properties, integrationConfiguration.properties) && Objects.equals(this.advanced, integrationConfiguration.advanced) && Objects.equals(this.notes, integrationConfiguration.notes) && Objects.equals(this.credentials, integrationConfiguration.credentials) && Objects.equals(this.selfUri, integrationConfiguration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.version, this.properties, this.advanced, this.notes, this.credentials, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationConfiguration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    advanced: ").append(this.toIndentedString(this.advanced)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

