/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecordingRetention
implements Serializable {
    private String conversationId = null;
    private String recordingId = null;
    private Date archiveDate = null;
    private ArchiveMediumEnum archiveMedium = null;
    private Date deleteDate = null;
    private Date exportDate = null;
    private Date exportedDate = null;
    private Date creationTime = null;

    public RecordingRetention conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public RecordingRetention recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public RecordingRetention archiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="archiveDate")
    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public RecordingRetention archiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of archive medium used. Example: CloudArchive")
    @JsonProperty(value="archiveMedium")
    public ArchiveMediumEnum getArchiveMedium() {
        return this.archiveMedium;
    }

    public void setArchiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
    }

    public RecordingRetention deleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="deleteDate")
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public RecordingRetention exportDate(Date exportDate) {
        this.exportDate = exportDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportDate")
    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date exportDate) {
        this.exportDate = exportDate;
    }

    public RecordingRetention exportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportedDate")
    public Date getExportedDate() {
        return this.exportedDate;
    }

    public void setExportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
    }

    public RecordingRetention creationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The creation time of the recording. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="creationTime")
    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingRetention recordingRetention = (RecordingRetention)o;
        return Objects.equals(this.conversationId, recordingRetention.conversationId) && Objects.equals(this.recordingId, recordingRetention.recordingId) && Objects.equals(this.archiveDate, recordingRetention.archiveDate) && Objects.equals((Object)this.archiveMedium, (Object)recordingRetention.archiveMedium) && Objects.equals(this.deleteDate, recordingRetention.deleteDate) && Objects.equals(this.exportDate, recordingRetention.exportDate) && Objects.equals(this.exportedDate, recordingRetention.exportedDate) && Objects.equals(this.creationTime, recordingRetention.creationTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversationId, this.recordingId, this.archiveDate, this.archiveMedium, this.deleteDate, this.exportDate, this.exportedDate, this.creationTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingRetention {\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    archiveDate: ").append(this.toIndentedString(this.archiveDate)).append("\n");
        sb.append("    archiveMedium: ").append(this.toIndentedString((Object)this.archiveMedium)).append("\n");
        sb.append("    deleteDate: ").append(this.toIndentedString(this.deleteDate)).append("\n");
        sb.append("    exportDate: ").append(this.toIndentedString(this.exportDate)).append("\n");
        sb.append("    exportedDate: ").append(this.toIndentedString(this.exportedDate)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ArchiveMediumEnumDeserializer.class)
    public static enum ArchiveMediumEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLOUDARCHIVE("CLOUDARCHIVE");

        private String value;

        private ArchiveMediumEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArchiveMediumEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArchiveMediumEnum value : ArchiveMediumEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArchiveMediumEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ArchiveMediumEnumDeserializer
    extends StdDeserializer<ArchiveMediumEnum> {
        public ArchiveMediumEnumDeserializer() {
            super(ArchiveMediumEnumDeserializer.class);
        }

        public ArchiveMediumEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ArchiveMediumEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

