/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetLocationSublocationsRequest {
    private String locationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public GetLocationSublocationsRequest withLocationId(String locationId) {
        this.setLocationId(locationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLocationSublocationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.locationId == null) {
            throw new IllegalStateException("Missing the required parameter 'locationId' when building request for GetLocationSublocationsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/locations/{locationId}/sublocations").withPathParameter("locationId", this.locationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String locationId) {
        return new Builder().withRequiredParams(locationId);
    }

    public static class Builder {
        private final GetLocationSublocationsRequest request = new GetLocationSublocationsRequest();

        private Builder() {
        }

        public Builder withLocationId(String locationId) {
            this.request.setLocationId(locationId);
            return this;
        }

        public Builder withRequiredParams(String locationId) {
            this.request.setLocationId(locationId);
            return this;
        }

        public GetLocationSublocationsRequest build() {
            if (this.request.locationId == null) {
                throw new IllegalStateException("Missing the required parameter 'locationId' when building request for GetLocationSublocationsRequest.");
            }
            return this.request;
        }
    }
}

